;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESTORE_DAT
;
; Purpose     :	Restores DAT data sets.
;
; Explanation : Requests name of file for restoration -- user should select an example file in one of the
;               DAT data directories.
;               All DAT data sets in the same root directory with the same name are then restored into IF data sets.
;               Other IF data sets are zeroed.
;
; Use         : < rcs_restore_dat, ids >
;
; Inputs      : ids  : STRUCTURE containing widget ids.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILE : STRING IF file name.
;
; Written     :	Version 0.0, 15/1/01
;
; Modified    :	Version 0.1, 14/03/01
;                 Removed ids from rcs_text argument list.
;               Version 0.2, 15/07/03
;                 Allow compressed DAT files.
;                 Removed ON_IOERROR.
;               Version 0.3, 31/07/03
;                 Added QUIET flag to rcs_open_file
;               Version 0.4, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.4, 09/10/03
;-
;**********************************************************

PRO rcs_restore_dat, ids

  ; get edb DAT file name
  ; allow compressed DAT files

  edb_file = ies_pickfile ( PATH=ies_get_dir('DATA',/RAPID), COUNT=edbc, FILTER=['c*_edb.*'], $
    TITLE='Select EDB file for restoring from DAT Format COMMON blocks or CANCEL', /MUST_EXIST  )

  ; get hk DAT file name

  hk_file = ies_pickfile ( PATH=ies_get_dir('DATA',/RAPID), COUNT=hkc, FILTER=['c*_hk.*'], $
    TITLE='Select HK file for restoring from DAT Format COMMON blocks or CANCEL', /MUST_EXIST  )

  ; deal with CANCEL

  IF edbc EQ 0 AND hkc EQ 0 THEN BEGIN
    rcs_text, 'No files selected for restoring'
    RETURN
  END

  ; set up structure for DAT processing info

  dat_info = {nm:0L,bm1:0L,bm2:0L,bm3:0L,hk:0L,ebd_unit:0L,hk_unit:0L,hkfc:0,sc:''}

  ; get current count of EDBs

  WIDGET_CONTROL, ids.showedb, GET_VALUE=edb_count

  dat_info.nm = edb_count.nm
  dat_info.bm1 = edb_count.bm1
  dat_info.bm2 = edb_count.bm2
  dat_info.bm3 = edb_count.bm3
  dat_info.hk = edb_count.hk

  ; get filenames and S/C

  IF edbc GT 0 THEN BEGIN

    edb_filename = strip_dirname(edb_file[0])

    dat_info.sc = STRMID(edb_filename,1,1)

  ENDIF

  IF hkc GT 0 THEN BEGIN

    hk_filename = strip_dirname(hk_file[0])

    dat_info.sc = STRMID(hk_filename,1,1)

    ; check consistency
    ; filenames are cn_yymmdd_*.*

    IF N_ELEMENTS(edb_filename) NE 0 THEN IF STRMID(hk_filename,0,10) NE STRMID(edb_filename,0,10) THEN BEGIN
      rcs_message, 'INCONSISTENT FILE NAMES', /INFORMATIONAL
      RETURN
    ENDIF

  ENDIF

  ; open files

  IF edbc GT 0 THEN BEGIN

    IF NOT rcs_open_file( edb_file[0], ebd_unit, EXTENSION='dat', /QUIET) THEN RETURN

    dat_info.edb_unit = edb_unit

  ENDIF

  IF hkc GT 0 THEN BEGIN

    IF NOT rcs_open_file( hk_file[0], hk_unit, EXTENSION='dat') THEN RETURN

    dat_info.hk_unit = hk_unit

  ENDIF

  ; store info for dat processing

  WIDGET_CONTROL, ids.sc, SET_UVALUE=dat_info, /NO_COPY

  ; start dat processing

  WIDGET_CONTROL, ids.sc, SEND_EVENT={DAT_EVENT,ID:ids.base,TOP:ids.base,HANDLER:ids.base}

END
