;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESTORE_IF
;
; Purpose     :	Restores IF data sets.
;
; Explanation : Restores multiple IF data sets for a specified day.
;               When called from RCS_BATCH days are supplied.
;               When called from RCS requests name of file for restoration -- user should select an example file in one of the
;               IF data directories. Source and SW version number are taken from specified file.
;               All IF data sets in the same root directory with the same name, source and Sw version number are then restored.
;               Other IF data sets are zeroed.
;
; Use         : < rcs_restore_if, ids, day >
;
; Inputs      : ids  : STRUCTURE containing widget ids.
;               day  : STRING IF day, format yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestal, espct IF data set.
;               Version 0.2, 5/3/01
;                 Added hourglass.
;                 Set data reset.
;               Version 0.3, 14/03/01
;                 Removed ids from rcs_text argument list.
;               Version 0.4, 16/03/01
;                 Modified to use rcs_get_ifnames.
;               Version 0.5, 03/05/01
;                 Added SINGLE keyword.
;               Version 0.6, 15/05/01
;                 Added CLEANBM2.
;               Version 0.7, 18/07/01
;                 Replaced keyword FILE with DAY.
;               Version 0.8, 08/02/02
;                 Added EPAD2.
;               Version 0.9, 03/09/03
;                 Changed default behaviour of rcs_get_iffiles.
;
; Version     :	Version 0.9, 03/09/03
;-
;**********************************************************

PRO rcs_restore_if, ids, sc, day, SINGLE=single

  ; global common blocks

  COMMON rcs_extract_block, tmax, data_reset

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  ; reset any IF data sets not restored
  ; set data_reset

  rcs_reset_if

  ; initialize restore variables

  input_header = 0

  input_data = 0

  ; NB days can be '' in which case KEYWORD_SET(days) returns 0
  ; day : yymmdd

  IF N_ELEMENTS(day) EQ 0 THEN BEGIN

    ; changed defaults

    rcs_get_days, sc, day, FILES=file, $
       /SINGLE, TITLE='Select file for restoring from Intermediate Format COMMON blocks or CANCEL'

    ; get source

    source = rcs_ifname_source(file)

    sw_version = rcs_ifname_sw_version(file)

  ENDIF

  IF day[0] EQ '' THEN RETURN

  IF KEYWORD_SET(single) THEN BEGIN

    ; just get single IF file
    ; If keyword set single then user selects which If data set ie file should be defined

    IF N_ELEMENTS(file) EQ 0 THEN rcs_message, /IMPLEMENTATION

    ifnames = FINDFILE(file,COUNT=count)

  ENDIF ELSE BEGIN

    ; get all IF files for this day

    ifnames = rcs_get_iffiles ( sc, COUNT=count, DAY=day, SOURCE=source, SW_VERSION=sw_version )

    ; select only latest versions

    IF count GT 0 THEN rcs_sort_ifnames, ifnames, COUNT=count

  ENDELSE

  IF count EQ 0 THEN BEGIN
    rcs_text, 'NO IF FILES SELECTED OF TYPE : '+ids.type+' '+day
    RETURN
  END

  ; if interactive then set hourglass

  IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  ; loop through IF files

  FOR k = 0, count-1 DO BEGIN

    ; restore file

    rcs_text, 'RESTORING IF DATA SET : '+ifnames[k], /OVERRIDE

    RESTORE, ifnames[k]

    ; sort out what IF data set it belongs to
    ; NB need to put longer datatypes before shorter

    IF STRPOS(input_header.datatype,'IES_E3DDBM') GE 0 THEN BEGIN
      e3ddbm_header = input_header
      e3ddbm_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EHIST') GE 0 THEN BEGIN
      ehist_header = input_header
      ehist_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_E3DD') GE 0 THEN BEGIN
      e3ddnm_header = input_header
      e3ddnm_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EPAD2') GE 0 THEN BEGIN
      epad2_header = input_header
      epad2_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EPAD') GE 0 THEN BEGIN
      epad_header = input_header
      epad_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_EHK') GE 0 THEN BEGIN
      ehk_header = input_header
      ehk_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEANBM2') GE 0 THEN BEGIN
      cleanbm2_header = input_header
      cleanbm2_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEANBM') GE 0 THEN BEGIN
      cleanbm_header = input_header
      cleanbm_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_ESPCT') GE 0 THEN BEGIN
      espct_header = input_header
      espct_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_CLEAN') GE 0 THEN BEGIN
      clean_header = input_header
      clean_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IES_PEDESTAL') GE 0 THEN BEGIN
      pedestal_header = input_header
      pedestal_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_He') GE 0 THEN BEGIN
      i3dd_header_He = input_header
      i3dd_data_He = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_H') GE 0 THEN BEGIN
      i3dd_header_H = input_header
      i3dd_data_H = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_I3DD_CNO') GE 0 THEN BEGIN
      i3dd_header_CNO = input_header
      i3dd_data_CNO = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_IPAD') GE 0 THEN BEGIN
      ipad_header = input_header
      ipad_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_HSPCT') GE 0 THEN BEGIN
      hspct_header = input_header
      hspct_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_ISPCT_He') GE 0 THEN BEGIN
      ispct_header_He = input_header
      ispct_data_He = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_ISPCT_CNO') GE 0 THEN BEGIN
      ispct_header_CNO = input_header
      ispct_data_CNO = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_MTRX') GE 0 THEN BEGIN
      mtrx_header = input_header
      mtrx_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGLBM') GE 0 THEN BEGIN
      sglbm_header = input_header
      sglbm_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL01') GE 0 THEN BEGIN
      sgl01_header = input_header
      sgl01_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL2') GE 0 THEN BEGIN
      sgl2_header = input_header
      sgl2_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'IIMS_SGL3') GE 0 THEN BEGIN
      sgl3_header = input_header
      sgl3_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'HK1') GE 0 THEN BEGIN
      hk1_header = input_header
      hk1_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'HK2') GE 0 THEN BEGIN
      hk2_header = input_header
      hk2_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'HK4') GE 0 THEN BEGIN
      hk4_header = input_header
      hk4_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'HK8') GE 0 THEN BEGIN
      hk8_header = input_header
      hk8_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'HK32') GE 0 THEN BEGIN
      hk32_header = input_header
      hk32_data = input_data
    ENDIF ELSE IF STRPOS(input_header.datatype,'SCINFO') GE 0 THEN BEGIN
      scinfo_header = input_header
      scinfo_data = input_data
    ENDIF ELSE BEGIN
      rcs_message, 'IF data set not recognized : '+input_header.datatype, /INFORMATIONAL
    ENDELSE

  ENDFOR

  ; find tmax

  tmax = rcs_get_tmax()

  ; set data reset

  data_reset = 3

END
