;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESTORE_IFDATA
;
; Purpose     :	Restores single IF data set.
;
; Explanation : Restores single IF data set.
;
; Use         : < res= rcs_restore_ifdata(sc_root, datatype, day, input_header, input_data, QUIET=quiet, FILE=file) >
;
; Inputs      : sc_root  : STRING giving SC root directory ie RAPID_1
;               datatype : STRING giving data type
;               day      : STRING giving day
;
; Opt. Inputs : None.
;
; Outputs     : res          : INT : 0=failed, 1=ok
;               input_header : STRUCTURE
;               input_data   : STRUCTURE
;
; Opt. Outputs: None.
;
; Keywords    : QUIET : Flag indicating reduced printout.
;               FILE  : STRING IF file name.
;                       If given then uses this rather than {sc, datatype, day}
;
; Written     :	Version 0.0, 16/2/01
;
; Modified    : Version 0.1, 14/03/01
;                 Removed ids from rcs_text argument list.
;               Version 0.2, 24/04/01
;                 Changed day argument to name.
;               Version 0.3, 19/07/01
;                 Changed name argument to day.
;               Version 0.4, 11/10/01
;                 Added QUIET keyword.
;               Version 0.5, 13/03/02
;                 Changed sc argument to sc_root.
;               Version 0.6, 09/04/02
;                 Added SW version.
;                 Changed printout slightly.
;               Version 0.7, 06/01/03
;                 Added FILE keyword.
;                 Removed POLAR keyword.
;               Version 0.8, 02/09/03
;                 Used rcs_if_filter.
;
; Version     :	Version 0.8, 02/09/03
;-
;**********************************************************

FUNCTION rcs_restore_ifdata, sc_root, datatype, day, input_header, input_data, QUIET=quiet, FILE=xfile

  ; initialize restore variables

  input_header = 0

  input_data = 0

  ; use xfile to avoid passing file back out

  IF NOT KEYWORD_SET(xfile) THEN BEGIN

    ; set up filename

    file = rcs_if_filter(sc_root,datatype,DAY=day,SOURCE=rcs_get_source(), SW_VERSION=rcs_get_sw_version())

    ; check file exists

    files = FINDFILE(file,COUNT=count)

    IF count EQ 0 THEN BEGIN

      rcs_message, 'FILE NOT FOUND : '+file, /INFORMATIONAL

      RETURN, 0

    ENDIF

    ; restore last file

    file = files[count-1]

  ENDIF ELSE file = xfile

  IF NOT KEYWORD_SET(quiet) THEN rcs_text, 'RESTORING IF DATA SET : '+file, /OVERRIDE

  ; restore data

  RESTORE, file

  ; check some data there

  IF NOT KEYWORD_SET(input_header) OR NOT KEYWORD_SET(input_data) THEN RETURN, 0

  ; return OK

  RETURN, 1

END
