;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESTORE_USE
;
; Purpose     :	Restore IF CFG file.
;
; Use         : < rcs_restore_use, FILE=file >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : FILE : STRING file name for restoration.
;
; Written     :	Version 0.0, Martin Carter, RAL, 9/3/01
;
; Modified    :	Version 0.1, 02/06/01
;                 Modified to give safe restore.
;               Version 0.2, 09/10/03
;                 Used ies get dir.
;               Version 0.3, 17/10/03
;                 Changed so that automaticaly inserts IFCFG directory if no directory defined.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************


PRO rcs_restore_use, FILE=file

  IF NOT KEYWORD_SET(file) THEN BEGIN

    restore_file = ies_pickfile(TITLE='RESTORE IF CONFIGURATION',COUNT=count,FILTER=['*.ifc'],$
                                /MUST_EXIST,PATH=ies_get_dir('IFCFG',/RAPID))

    IF count NE 1 THEN RETURN

  ENDIF ELSE BEGIN

    IF strip_dirname(file) EQ file THEN restore_file = concat_dir(ies_get_dir('IFCFG',/RAPID),file) $
      ELSE restore_file = file

  ENDELSE

  use = 0

  RESTORE, restore_file

  ; get current output_info default

  rcs_set_use, 0

  default_use = rcs_get_use()

  ; copy restored tags to default

  copy_struct, use, default_use

  ; store new use

  rcs_set_use, default_use

  rcs_text, 'RESTORED IF CONFIGURATION FILE : '+restore_file, /OVERRIDE

END
