;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SAVE_IF
;
; Purpose     :	Saves out all RAL Intermediate format data.
;
; Explanation : Each RAL IF data set is saved to a separate file.
;               The file name has format 'ifdir\ifname\userdefined'.
;               Checks USE to see what to save.
;               Saves to file even if no data.
;
; Use         : < rcs_save_if >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : DAY : STRING IF day in format yymmdd.
;
; Written     :	Version 0.0, 17/09/00
;
; Modified    : Version 0.1, 6/2/01
;                 Added pedestals and espct IF data set.
;               Version 0.2, 14/03/01
;                 Added some printout.
;               Version 0.3, 09/05/01
;                 Added HOURGLASS.
;               Version 0.4, 15/05/01
;                 Added CLEANBM2.
;               Version 0.5, 18/07/01
;                 Modified to use extended IF names.
;               Version 0.6, 30/08/01
;                 Modified so that saves to file even if no data.
;               Version 0.7, 07/02/02
;                 Changed print out.
;               Version 0.8, 08/02/02
;                 Added EPAD2.
;               Version 0.9, 13/03/02
;                 Added rcs_ifname_day.
;               Version 1.0, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 1.0, 08/10/03
;-
;**********************************************************

PRO rcs_save_if, DAY=day

  ; global common blocks

  COMMON rcs_e3ddnm_block, e3ddnm_header, e3ddnm_data

  COMMON rcs_ehist_block, ehist_header, ehist_data

  COMMON rcs_clean_block, clean_header, clean_data

  COMMON rcs_cleanbm_block, cleanbm_header, cleanbm_data

  COMMON rcs_cleanbm2_block, cleanbm2_header, cleanbm2_data

  COMMON rcs_espct_block, espct_header, espct_data

  COMMON rcs_pedestal_block, pedestal_header, pedestal_data

  COMMON rcs_e3ddbm_block, e3ddbm_header, e3ddbm_data

  COMMON rcs_epad_block, epad_header, epad_data

  COMMON rcs_epad2_block, epad2_header, epad2_data

  COMMON rcs_ehk_block, ehk_header, ehk_data

  COMMON rcs_i3dd_H_block, i3dd_header_H, i3dd_data_H

  COMMON rcs_i3dd_He_block, i3dd_header_He, i3dd_data_He

  COMMON rcs_i3dd_CNO_block, i3dd_header_CNO, i3dd_data_CNO

  COMMON rcs_ipad_block, ipad_header, ipad_data

  COMMON rcs_hspct_block, hspct_header, hspct_data

  COMMON rcs_ispct_He_block, ispct_header_He, ispct_data_He

  COMMON rcs_ispct_CNO_block, ispct_header_CNO, ispct_data_CNO

  COMMON rcs_mtrx_block, mtrx_header, mtrx_data

  COMMON rcs_sglbm_block, sglbm_header, sglbm_data

  COMMON rcs_sgl01_block, sgl01_header, sgl01_data

  COMMON rcs_sgl2_block, sgl2_header, sgl2_data

  COMMON rcs_sgl3_block, sgl3_header, sgl3_data

  COMMON rcs_hk1_block, hk1_header, hk1_data

  COMMON rcs_hk2_block, hk2_header, hk2_data

  COMMON rcs_hk4_block, hk4_header, hk4_data

  COMMON rcs_hk8_block, hk8_header, hk8_data

  COMMON rcs_hk32_block, hk32_header, hk32_data

  COMMON rcs_scinfo_block, scinfo_header, scinfo_data

  IF NOT KEYWORD_SET(day) THEN BEGIN

    file = ies_pickfile ( PATH=ies_get_dir('IF',/RAPID), COUNT=count, $
             TITLE='Select file name for saving IF format data (Directory is ignored)' )

    ; deal with CANCEL

    IF count EQ 0 THEN RETURN

    day = rcs_ifname_day(file[0])

  ENDIF

  ; if interactive then set hourglass

  ids = rcs_get_ids()

  IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  ; get DATA sets to save

  use = rcs_get_use()

  IF use.e3dd     THEN rcs_save_ifset, e3ddnm_header, e3ddnm_data, day, DATATYPE='IES_E3DD', COUNT=count
  IF use.clean    THEN rcs_save_ifset, clean_header, clean_data, day, DATATYPE='IES_CLEAN', COUNT=count
  IF use.cleanbm  THEN rcs_save_ifset, cleanbm_header, cleanbm_data, day, DATATYPE='IES_CLEANBM', COUNT=count
  IF use.cleanbm2 THEN rcs_save_ifset, cleanbm2_header, cleanbm2_data, day, DATATYPE='IES_CLEANBM2', COUNT=count
  IF use.espct    THEN rcs_save_ifset, espct_header, espct_data, day, DATATYPE='IES_ESPCT', COUNT=count
  IF use.pedestal THEN rcs_save_ifset, pedestal_header, pedestal_data, day, DATATYPE='IES_PEDESTAL', COUNT=count
  IF use.ehist    THEN rcs_save_ifset, ehist_header, ehist_data, day, DATATYPE='IES_EHIST', COUNT=count
  IF use.e3ddbm   THEN rcs_save_ifset, e3ddbm_header, e3ddbm_data, day, DATATYPE='IES_E3DDBM_16', COUNT=count
  IF use.epad     THEN rcs_save_ifset, epad_header, epad_data, day, DATATYPE='IES_EPAD_16', COUNT=count
  IF use.epad2    THEN rcs_save_ifset, epad2_header, epad2_data, day, DATATYPE='IES_EPAD2', COUNT=count
  IF use.ehk      THEN rcs_save_ifset, ehk_header, ehk_data, day, DATATYPE='IES_EHK', COUNT=count
  IF use.i3dd     THEN rcs_save_ifset, i3dd_header_H, i3dd_data_H, day, DATATYPE='IIMS_I3DD_H', COUNT=count
  IF use.i3dd     THEN rcs_save_ifset, i3dd_header_He, i3dd_data_He, day, DATATYPE='IIMS_I3DD_He', COUNT=count
  IF use.i3dd     THEN rcs_save_ifset, i3dd_header_CNO, i3dd_data_CNO, day, DATATYPE='IIMS_I3DD_CNO', COUNT=count
  IF use.ipad     THEN rcs_save_ifset, ipad_header, ipad_data, day, DATATYPE='IIMS_IPAD_16', COUNT=count
  IF use.hspct    THEN rcs_save_ifset, hspct_header, hspct_data, day, DATATYPE='IIMS_HSPCT', COUNT=count
  IF use.ispct    THEN rcs_save_ifset, ispct_header_He, ispct_data_He, day, DATATYPE='IIMS_ISPCT_He', COUNT=count
  IF use.ispct    THEN rcs_save_ifset, ispct_header_CNO, ispct_data_CNO, day, DATATYPE='IIMS_ISPCT_CNO', COUNT=count
  IF use.mtrx     THEN rcs_save_ifset, mtrx_header, mtrx_data, day, DATATYPE='IIMS_MTRX', COUNT=count
  IF use.sglbm    THEN rcs_save_ifset, sglbm_header, sglbm_data, day, DATATYPE='IIMS_SGLBM', COUNT=count
  IF use.sgl01    THEN rcs_save_ifset, sgl01_header, sgl01_data, day, DATATYPE='IIMS_SGL01', COUNT=count
  IF use.sgl2     THEN rcs_save_ifset, sgl2_header, sgl2_data, day, DATATYPE='IIMS_SGL2', COUNT=count
  IF use.sgl3     THEN rcs_save_ifset, sgl3_header, sgl3_data, day, DATATYPE='IIMS_SGL3', COUNT=count
  IF use.hk1      THEN rcs_save_ifset, hk1_header, hk1_data, day, DATATYPE='HK1', COUNT=count
  IF use.hk2      THEN rcs_save_ifset, hk2_header, hk2_data, day, DATATYPE='HK2', COUNT=count
  IF use.hk4      THEN rcs_save_ifset, hk4_header, hk4_data, day, DATATYPE='HK4', COUNT=count
  IF use.hk8      THEN rcs_save_ifset, hk8_header, hk8_data, day, DATATYPE='HK8', COUNT=count
  IF use.hk32     THEN rcs_save_ifset, hk32_header, hk32_data, day, DATATYPE='HK32', COUNT=count
  IF use.scinfo   THEN rcs_save_ifset, scinfo_header, scinfo_data, day, DATATYPE='SCINFO', COUNT=count

  rcs_text, 'SAVED '+rcs_strtrim(count)+' IF DATA SETS', /OVERRIDE

END
