;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SAVE_IFSET
;
; Purpose     :	Save a single RAL Intermediate format data set.
;
; Explanation : Each RAL IF data set is saved to a separate file in a
;               directory specified by the datatype.
;
; Use         : < RCS_SAVE_IFSET, input_header, all_data, day >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT incremented count if saved OK
;
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 26/1/01
;                 Changed form of words to differentiate between ifdata and ifdata/RAPID_n
;                 directories not existing.
;                 Used COMPRESS keyword in save if version 5.4.
;               Version 0.2, 14/03/01
;                 Added some printout.
;               Version 0.3, 14/06/01
;                 Created new subroutine.
;               Version 0.4, 19/07/01
;                 Changed name argument to day..
;               Version 0.5, 30/08/01
;                 Started changes so that can save if no data.
;                 Added DATATYPE keyword.
;               Version 0.6, 07/02/02
;                 Added COUNT keyword.
;               Version 0.7, 08/04/02
;                 Used full version for file name.
;               Version 0.8, 03/09/03
;                 Removed some preliminary code.
;               Version 0.9, 07/11/03
;                 Changed rcs get ifdir to rcs get subdir.
;
; Version     :	Version 0.9, 07/11/03
;-
;**********************************************************

PRO rcs_save_ifset, input_header, all_data, day, DATATYPE=datatype, COUNT=count

  IF NOT KEYWORD_SET(count) THEN count = 0

  IF NOT KEYWORD_SET(input_header) THEN BEGIN

    RETURN

  ENDIF ELSE BEGIN

    datatype = input_header.datatype

    input_data = all_data[0:input_header.npoints-1]

    version = input_header.version

  ENDELSE

  CATCH, error_status

  IF error_status NE 0 THEN BEGIN

    rcs_message, 'Error message:'+!ERR_STRING,/INFORMATIONAL
    rcs_message, 'Data not saved : '+datatype,/INFORMATIONAL

    RETURN

  ENDIF

  ; get IF directory name and create directory if needed

  dir = rcs_get_subdir('IF', STRMID(datatype,6,1), STRMID(datatype,8,64))

  IF NOT KEYWORD_SET(dir) THEN RETURN

  name = rcs_if_filter(DAY=day, VERSION=version)

  file = concat_dir(dir,name)

  rcs_text, 'SAVING IF DATA SET : '+concat_dir(STRMID(datatype,8,64),name), /OVERRIDE

  IF !VERSION.release GE '5.4' THEN BEGIN

    SAVE, input_header, input_data, FILE=file, /COMPRESS

  ENDIF ELSE BEGIN

    SAVE, input_header, input_data, FILE=file

  ENDELSE

  ; incrment count

  count = count + 1

END
