;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SET_EDB_COUNT
;
; Purpose     :	Sets EDB count.
;
; Explanation : Sets EDB count.
;
; Use         : < rcs_Set_edb_count, value >
;
; Inputs      : value : STRUCTURE containing EDB counts.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 11/2/01
;
; Modified    : Version 0.1, 13/03/01
;                 Changed use of silent flag.
;
; Version     :	Version 0.1, 13/03/01
;-
;**********************************************************

PRO rcs_set_edb_count, value

  COMMON rcs_edb_count_local, edb_count

  ; save edb count to COMMON

  edb_count = value

  ; update display

  IF NOT rcs_get_silent() THEN BEGIN

    ids = rcs_get_ids()

    IF WIDGET_INFO(ids.showedb,/VALID_ID) THEN $
      WIDGET_CONTROL, ids.showedb, SET_VALUE=edb_count

  ENDIF

END
