;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SORT_IFNAMES
;
; Purpose     :	Gets names of all IF files for given day and S/C.
;
; Explanation : Gets names of all IF files for given day and S/C.
;
; Use         : < rcs_sort_ifnames, ifnames >
;
; Inputs      : ifnames   : STRARR IF file names with same date.
;
; Opt. Inputs : None.
;
; Outputs     : ifnames : STRARR latest versions only of IF files with same date.
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of if files
;
; Written     :	Version 0.0, 16/03/01
;
; Modified    : Version 0.1, 22/03/01
;                 Modified to use rcs get iffiles.
;               Version 0.2, 18/07/01
;                 Added argument sc to argument list. Can only process files from a single directory anyway.
;                 Replaced argument file with day.
;                 Changed name to rcs_sort_ifnames.
;
; Version     :	Version 0.1, 22/03/01
;-
;**********************************************************

PRO rcs_sort_ifnames, ifnames, COUNT=count

  ; sort so that latest versions are last

  ifnames = ifnames[SORT(ifnames)]

  ; strip out paths and names

  names = strip_dirname(ifnames, PATH=paths)

  ; get unique paths

  ifnames = ifnames[UNIQ(paths)]

  count = N_ELEMENTS(ifnames)

END
