;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SUBC
;
; Purpose     : Controls data complete flag and invalid subc flag.
;
; Explanation : Checks if subc continuous during capture of subcommutated data.
;               Watches subc invalid flag. If set then sets error flag in IF data set.
;               Checks if subc implies new sample.
;               If last packet for sample then cancels sample incomplete flag.
;               Does not work if no = 1.
;
; Use         : < rcs_subc, header, data, subc, no, flag >
;
; Inputs      : header      : STRUCTURE containing IF data set info
;               data        : STRUCTRUE ARRAY containing IF data
;               subc        : INT subcommutation index
;               no          : INT degree of subcommutation for this data (>1)
;               flag        : BYTE flag bits
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 17/9/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

FUNCTION rcs_subc, header, data, subc, no, flag

  ; get subc invalid flag

  subc_invalid = (flag AND '20'X) NE 0

  ; check if any data yet

  IF NOT KEYWORD_SET(header) THEN BEGIN

    ; no data yet

    ; cancel subc invalid flag if subc = 0

    IF subc_invalid THEN IF subc EQ 0 THEN flag = flag AND 'DF'X

    ; if subc ne 0 then set subc invalid flag
    ; NB use may be turned on during processing

    IF subc NE 0 THEN flag = flag OR '20'X

    ; set data incomplete flag if more expected

    IF subc LT no-1 THEN flag = flag OR '80'X

    ; create new sample

    RETURN, 1

  ENDIF ELSE BEGIN

    ; previous data exists

    IF subc EQ no-1 THEN BEGIN

      ; completes sample

      ; remove data incomplete flag on current sample

      data[header.npoints-1].flag = data[header.npoints-1].flag AND '7F'X

      ; check if subc invalid on current sample

      IF subc_invalid THEN data[header.npoints-1].flag = data[header.npoints-1].flag OR '20'X

      ; don't create new sample

      RETURN, 0

    ENDIF ELSE IF subc EQ 0 THEN BEGIN

      ; starts new sample

      ; check if subc invalid

      IF subc_invalid THEN BEGIN

        ; check if last sample incomplete

        IF (data[header.npoints-1].flag AND '80'X) NE 0 THEN BEGIN

          ; remove data incomplete flag on last sample

          data[header.npoints-1].flag = data[header.npoints-1].flag AND '7F'X

          ; set subc invalid flag on last sample

          data[header.npoints-1].flag = data[header.npoints-1].flag OR '20'X

        ENDIF

        ; cancel subc invalid flag on new sample since subc = 0

        flag = flag AND 'DF'X

      ENDIF

      ; set sample incomplete flag

      flag = flag OR '80'X

      ; create new sample

      RETURN, 1

    ENDIF ELSE IF subc_invalid THEN BEGIN

      ; end previous samplle and create new sample

      ; remove data incomplete flag on last sample

      data[header.npoints-1].flag = data[header.npoints-1].flag AND '7F'X

      ; set subc invalid flag on last sample

      data[header.npoints-1].flag = data[header.npoints-1].flag OR '20'X

      ; leave subc_invalid flag in new sample since subc /= 0

      ; set sample incomplete flag

      flag = flag OR '80'X

      ; create new sample

      RETURN, 1

    ENDIF ELSE BEGIN

      ; carry on

      RETURN, 0

    ENDELSE

  ENDELSE

END
