;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TEST_BM
;
; Purpose     :	Returns position of first set of sync markers '146f2e'
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_test_bm, edb, hist_mode, strip

  ; e3dd

  e3dd = (INDGEN(12)+1)#REPLICATE(1,96)

  edb['478'X:'478'X+1152-1] = BYTE(e3dd)

  ; i3dd

  i3dd = REFORM(REPLICATE(1,12)#(INDGEN(8)+1),96)#REPLICATE(1,6)

  edb['215'X:'215'X+576-1] = BYTE(i3dd)

  ; sgl0  : n/a  

  ; sgl1

  edb['156'X:'156'X+80-1] = BYTE([1,2,3,4,5]#REPLICATE(1,16))

END
