;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_TEST_HK
;
; Purpose     :	Returns position of first set of sync markers '146f2e'
;
; Use         : < result = RCS_GET_CCSNM_SYNC(data) >
;
; Inputs      : data : BYTARR CCSNM EDB data stream.
;
; Opt. Inputs : None.
;
; Outputs     : result : LONARR indices of sync markers encountered or -1 if none
;
; Opt. Outputs: None.
;
; Keywords    : COUNT : INT returns no. of markers found.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : EDB.
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_test_hk, hk, hkfcr

  ; eristahv, eristohv, eridefhv

  hk[11] = hkfcr*8

  hk[12] = (hkfcr*8 + 8) MOD 256

  hk[13] = (hkfcr*8 + 16) MOD 256

END
