;+
; Project     :	CLUSTER - PEACE
;
; Name        :	RCS_GET_PED_CALIBRATION
;
; Purpose     : Retrieves pedestal calibration data for RAPID.
;
; Explanation :	This routine restores the relevant pedestal calibration data provided it has not already
;               been stored and stores in the pedestal calibration data COMMON block.
;
; Use         : < rcs_get_ped_calibration, sc >
;
; Inputs      : sc : STRING spacecraft
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      :	pedestal_calibration_block.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	Adapted from ies get samples.
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/09/00
;
; Modified    :	Version 0.1, 02/10/03
;                 Changed file from keyword to argument to remove POLAR dependence.
;               Version 0.2. 12/12/03
;                 Changed to more explicit logic.
;               Version 0.3, 09/01/04
;                 Added check that calibration file exists.
;                 Set calibration file after restore to avoid common block being set up before restore worked.
;               Version 0.4, 30/01/04
;                 Adapted from ies get pedestal_calibration
;                 Used routines rather than calibration files to store pedestal histogram data.
;
; Version     :	Version 0.4, 30/01/04
;-
;**********************************************************

PRO rcs_get_ped_calibration, sc

  ; for RAPID (04/12/03)
  ; pedestals    : FLTARR[9,256,4]
  ; temperatures : FLOAT

  COMMON pedestal_calibration_block, pedestals, temperatures, calibration_sc

  ; check if already have calibration file

  IF N_ELEMENTS(calibration_sc) NE 0 THEN BEGIN

    IF calibration_sc EQ sc THEN RETURN

  ENDIF

  CASE sc OF
    '1' : rcs_sc1ped, pedestals, temperatures
    '2' : rcs_sc2ped, pedestals, temperatures
    '3' : rcs_sc3ped, pedestals, temperatures
    '4' : rcs_sc4ped, pedestals, temperatures
  ENDCASE

  ; put this after restore in case restore fails

  calibration_sc = sc

  ; rearrange pedestals
  ; returned as [256,9,4]
  ; want [9,256,4]

  pedestals = TRANSPOSE(pedestals,[1,0,2])

END
