;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_DAT
;
; Purpose     :	Adds DATA files to current file selection.
;
; Explanation : Adds DATA files to current file selection.
;
; Use         : < days = rcs_add_dat( ids) >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;
; Opt. Inputs : None.
;
; Outputs     : days   : STRARR output list of sorted, unique days in format yymmdd
;
; Opt. Outputs: None.
;
; Keywords    : SC     : STRING defining S/C :'1','2','3','4'
;               TSTART : STRING start date in form yymmdd.
;               TSTOP  : STRING stop date in form yymmdd.
;               HK     : FLAG indicating should only process HK files.
;               BM     : FLAG indicating should only process BM files (ignored)
;               NM     : FLAG indicating should only process NM files (ignored)
;
; Written     :	Version 0.0, Martin Carter, RAL, 6/1/01
;
; Modified    : Version 0.1, 27/1/01
;                 Added version options.
;               Version 0.2, 11/2/01
;                 Added batch mode.
;                 Changed sc selection.
;               Version 0.3, 2/3/01
;                 Added DAYS keyword.
;           	Version 0.4, 9/3/01
;                 Added TSTART and TSTOP keywords.
;                 Removed FILTER.
;               Version 0.5, 23/03/01
;                 Changed to rcs_sort_days.
;                 Fixed bug with tstart and tstop.
;               Version 0.6, 25/05/01
;                 Added HK keyword.
;               Version 0.7, 31/05/01
;                 Added BM and NM keywords.
;               Version 0.8, 12/07/02
;                 Use first of multiple directories.
;               Version 0.9, 17/01/03
;                 Changed routine to function returning days.
;               Version 1.0, 15/07/03
;                 Allow compressed DAT files.
;               Version 1.1, 09/10/03
;                 Used ies get dir.
;               Version 1.2, 09/01/04
;                 Fixed minor bug if count=0 and added printout.
;
; Version     :	Version 1.2, 09/01/04
;-
;**********************************************************

FUNCTION rcs_add_dat, ids, SC=sc, TSTART=tstart, TSTOP=tstop, HK=hk, NM=nm, BM=bm

  ; seems to do things twice
  ; could be better

  ; get S/C required

  IF NOT KEYWORD_SET(sc) THEN sc = rcs_sc_selection(ids)

  ; test if root directory defined

  root = ies_get_dir('DATA',/RAPID)

  ; only use first of multiple directories

  roots = break_path(root,/NOCURRENT)

  root = roots[0]

  IF root EQ '' THEN BEGIN

    rcs_message, 'WARNING, NO DATA DIRECTORY DEFINED', /INFORMATIONAL

    RETURN, ''

  ENDIF

  ; get list of all EDB files
  ; allow compressed files

  edb_files = FINDFILE(concat_dir(root,'c'+sc+'_*_edb.*'), COUNT=edb_count)

  ; get list of all HK files
  ; allow compressed files

  hk_files = FINDFILE(concat_dir(root,'c'+sc+'_*_hk.*'), COUNT=hk_count)

  ; extract day codes

  IF edb_count GT 0 THEN days = STRMID(strip_dirname(edb_files),3,6)

  IF hk_count GT 0 THEN IF N_ELEMENTS(days) GT 0 THEN $
    days = [days,STRMID(strip_dirname(hk_files),3,6)] ELSE $
    days = STRMID(strip_dirname(hk_files),3,6)

  IF N_ELEMENTS(days) EQ 0 THEN BEGIN

    rcs_message, 'WARNING, NO VALID DAYS IN DATA DIRECTORY FOR SC'+sc, /INFORMATIONAL

    RETURN, ''

  ENDIF

  ; select and sort days

  list = rcs_sort_days ( days, TSTART=tstart, TSTOP=tstop, COUNT=count)

  ; check count

  IF count EQ 0 THEN rcs_no_days, sc, TSTART=tstart, TSTOP=tstop ELSE days = days[list]

  ; define codes

  IF KEYWORD_SET(hk) THEN BEGIN

    codes = ['hk']

    indices = [1]

  ENDIF ELSE BEGIN

    codes = ['edb','hk']

    indices = INDGEN(N_ELEMENTS(codes))

  ENDELSE

  ; loop through file streams adding file names

  FOR n = 0, N_ELEMENTS(ids.in)-1 DO BEGIN

    ; get files

    files = ''

    FOR k = 0, count-1 DO BEGIN

      ; get file name

      filename = concat_dir(root,'c'+sc+'_'+days[k]+'_'+codes[n]+'.*')

      ; check file exists

      filenames = FINDFILE(filename,COUNT=fcount)

      IF fcount EQ 1 THEN BEGIN

        files = [files,filenames[0]]

        IF N_ELEMENTS(days_list) GT 0 THEN days_list = [days_list,days[k]] ELSE days_list = days[k]

      ENDIF ELSE BEGIN

          rcs_message, 'WARNING, FILE NOT FOUND : '+filename, /INFORMATIONAL

      ENDELSE

    ENDFOR

    ; add files

    IF N_ELEMENTS(files) GT 1 THEN BEGIN

      files = files[1:*]

      ; set file list

      rcs_set_files, indices[n], files

    ENDIF

  ENDFOR

  list = rcs_sort_days(days_list)

  days_list = days_list[list]

  RETURN, days_list

END
