;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_DAYS
;
; Purpose     :	Returns days selected.
;
; Explanation : Adds DATA files to current day selection.
;               Defaults to looking for IF files.
;               Searches for all classes of files.
;
; Use         : < days = rcs_add_days( sc ) >
;
; Inputs      : sc     : STRING defining S/C :'1','2','3','4'
;
; Opt. Inputs : None.
;
; Outputs     : days   : STRARR output list of sorted, unique days in format 'yymmdd'.
;
; Opt. Outputs: None.
;
; Keywords    : TSTART : STRING start date in form yymmdd.
;               TSTOP  : STRING stop date in form yymmdd.
;               SCI    : FLAG indicating using SCI files.
;
; Written     :	Version 0.0, Martin Carter, RAL, 22/03/01
;
; Modified    : Version 0.1, 25/07/01
;                 Changed output to days.
;                 Modified to allow differnt sources.
;               Version 0.2, 13/03/02
;                 Added rcs_ifname_day.
;               Version 0.3, 04/07/02
;                 Renamed routine and included SCI files.
;               Version 0.4, 17/01/03
;                 Removed DAYS keyword.
;               Version 0.5, 03/09/03
;                 Changed default behaviour of rcs_get_iffiles.
;               Version 0.6, 09/01/04
;                 Added printout if no days found for SC.
;
; Version     :	Version 0.6, 09/01/04
;-
;**********************************************************

FUNCTION rcs_add_days, sc, TSTART=tstart, TSTOP=tstop, SCI=sci

  IF KEYWORD_SET(sci) THEN BEGIN

    ; get all sci files for SC

    files = rcs_get_scifiles ( sc, COUNT=count)

    IF count EQ 0 THEN GOTO, NODAYS

    ; select and sort days
    ; days has form yymmdd

    days = rcs_sciname_day(files)

  ENDIF ELSE BEGIN

    ; get iffiles for specified source

    files = rcs_get_iffiles ( sc, COUNT=count)

    IF count EQ 0 THEN GOTO, NODAYS

    ; select and sort days
    ; days has form yymmdd

    days = rcs_ifname_day(files)

  ENDELSE

  list = rcs_sort_days ( days, TSTART=tstart, TSTOP=tstop, COUNT=count)

  IF count EQ 0 THEN GOTO, NODAYS

  days = days[list]

  ; return full file names

  RETURN, days

NODAYS:

  rcs_no_days, sc, TSTART=tstart, TSTOP=tstop

  RETURN, ''

END
