;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_FILES
;
; Purpose     :	Adds new files to current file selection.
;
; Explanation : Allows new files to be interleaved with current file list as stored in widget.
;
; Use         : < rcs_add_files, ids, n >
;
; Inputs      : ids : STRUCTURE containing widget IDs.
;               n : INT index into ids.in[].
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    : Version 0.1, MKC, 19/1/01
;                 Added file filter to incorporate .dat type.
;                 Changed storage of file unit and names.
;                 Added rcs_version.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text argument list.
;               Version 0.3, 12/07/02
;                 Added uppercase to argument list.
;                 Added SCI type.
;                 Use first of multiple directories.
;               Version 0.4, 15/07/03
;                 Allow compressed files to be used.
;               Version 0.5, 09/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.5, 09/10/03
;-
;**********************************************************

PRO rcs_add_files, ids, n

  ; set up filter
  ; allow compressed files

  CASE ids.type OF
    'GSEOS' : filter = ['*']
    'DDS' : CASE ids.in[n].type OF
              'NM' : filter = ['*rn.*','*RN.*']
              'BM' : filter = ['*rb.*','*RB.*']
              'HK' : filter = ['*rh.*','*RH.*']
              ELSE : rcs_message, /IMPLEMENTATION
            ENDCASE
    'DAT' : CASE ids.in[n].type OF
              'EDB' : filter = ['*_edb.*']
              'HK' : filter = ['*_hk.*']
              ELSE : rcs_message, /IMPLEMENTATION
            ENDCASE
    'SCI' : filter = ['*']
    ELSE : rcs_message, /IMPLEMENTATION
  ENDCASE

  ; test if root directory defined

  root = ies_get_dir('DATA',/RAPID)

  ; only use first of multiple directories

  roots = break_path(root,/NOCURRENT)

  root = roots[0]

  ; get new file names

  IF rcs_version() THEN $
    new_files = ies_pickfile ( /MULTIPLE_FILES, COUNT=new_count, FILTER=filter, $
      PATH=root, $
      TITLE='Select '+ids.in[n].type+' INPUT file(s) or CANCEL',/MUST_EXIST) $
  ELSE $ ; ie unix with IDL 5.0.3
    new_files = ies_pickfile ( COUNT=new_count, FILTER=filter,$
      PATH=root, $
      TITLE='Select '+ids.in[n].type+' INPUT file(s) or CANCEL')

  ; deal with CANCEL

  IF new_count EQ 0 THEN RETURN

  ; get current state of each file type

  info = rcs_get_info()

  ; get file names

  files = rcs_get_files(n)

  ; check if any existing files

  IF files[0] NE '' THEN BEGIN

    ; store top file name

    top_file = files[0]

    ; add to existing files

    files = [files,new_files]

  ENDIF ELSE BEGIN

    ; set up new files

    files = new_files

  ENDELSE

  ; arrange into time order

  files = files[SORT(files)]

  ; ignore any duplication

  files = files[UNIQ(files)]

  ; check that if top file open then still top file

  IF KEYWORD_SET(info[n].unit) THEN BEGIN

    IF top_file NE files[0] THEN BEGIN

      rcs_text, 'WARNING, NEW FILE PRIOR TO CURRENT OPEN FILE'

      RETURN

    ENDIF

  ENDIF

  ; set file list

  rcs_set_files, n, files

  ; update info

  info[n].nfiles = N_ELEMENTS(files)

  info[n].file = files[0]

  ; save info on current state of each file type

  rcs_set_info, info

  RETURN

END
