;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_ADD_TO_COMMON
;
; Purpose     :	Adds data packet to COMMON blocks
;
; Explanation : Adds data packet to either science or housekeeping COMMON blocks.
;               Keeps track of how much data added to each COMMON block.
;               When have required amount of data returns 1 else returns 0.
;
; Use         : < result = RCS_ADD_TO_COMMON(header, data) >
;
; Inputs      : header : Structure giving packet header.
;               data  : BYTARR data packet
;
; Opt. Inputs : None.
;
; Outputs     : result : INT indicating whether sufficient data accumulated.
;                         0 : more data required
;                         1 : sufficinet data acquired
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 21/1/01
;                 Added CCSBM3 for completeness.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text argument list and this argument list.
;
; Version     :	Version 0.2, 14/03/01
;-
;**********************************************************

FUNCTION rcs_add_to_common, header, data

  ; global COMMON blocks
  ; data : BYTARR[data_size] if data_size = 0 then data = 0
  ; times : STRUCTURE array[ccsnm_ntimes] of {DATA TIMES}


  ; data passed to routine rcs_extract

  COMMON rcssc_data_block, rcssc_data, rcssc_headers
  COMMON rcshk_data_block, rcshk_data, rcshk_headers

  ; local COMMON block -- may be used by multiple threads

  COMMON rcs_in_common_local, hk_new, sc_new

  ; set constants
  ; NB NM/BM2 EDB has size 512 bytes
  ; BM1 EDB has size 2304 bytes
  ; HK packet has size ?

  rcssc_data_required = 5120 ; 10 NM EDBs
  rcshk_data_required = 5120

  ; initialize new variables

  IF N_ELEMENTS(sc_new) EQ 0 THEN sc_new = 0L

  IF N_ELEMENTS(hk_new) EQ 0 THEN hk_new = 0L

  ; put in appropriate COMMON block

  CASE header.info.type OF

    'CCSNM'  : rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

    'CCSBM'  : rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

    'CCSBM1' : rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

    'CCSBM2' : rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

    'CCSBM3' : rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

    'CCSHK'  : rcs_do_common, data, header, rcshk_data, rcshk_headers, hk_new

    'EDB'    : BEGIN

                 IF data[0] EQ '14'X AND data[1] EQ '6f'X THEN BEGIN

                   IF data[2] EQ '2e'X THEN BEGIN
                     header.info.type = 'CCSNM'
                     data = data[0:511]
                   ENDIF ELSE IF data[2] EQ '3d'X THEN BEGIN
                     header.info.type = 'CCSBM1'
                     data = data[0:2303]
                   ENDIF ELSE IF data[2] EQ '8b'X THEN BEGIN
                     header.info.type = 'CCSBM3'
                     data = data[0:2339]
                   ENDIF ELSE rcs_message, 'INVALID EDB PACKET'

                   rcs_do_common, data, header, rcssc_data, rcssc_headers, sc_new

                 ENDIF ELSE rcs_message, 'INVALID EDB PACKET'

               END

    'HK'     : BEGIN
                 IF N_ELEMENTS(data) NE 40 Then stop
                 header.info.type = 'CCSHK'
                 rcs_do_common, data, header, rcshk_data, rcshk_headers, hk_new
               END

    'MESSAGE' : BEGIN
                  list = WHERE(data NE 0, count)
                  IF count GT 0 THEN rcs_text, 'rcs_message:'+STRING(data[list])
                END

     ELSE : rcs_text, 'UNPROCESSED BLOCK BODY ='+header.info.type

  ENDCASE

  ; check if have sufficient data to stop

  IF sc_new GE rcssc_data_required THEN BEGIN
    sc_new = 0L
    RETURN, 1
  ENDIF

  IF hk_new GE rcshk_data_required THEN BEGIN
    hk_new = 0L
    RETURN, 1
  ENDIF

  ; signal not sufficient data yet

  RETURN, 0

END
