;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_IF
;
; Purpose     :	Batch process IF files.
;
; Explanation : Batch process IF files.
;               If days not defined then asks user to specify days and sc
;
; Use         : < rcs_batch_if >
;
; Inputs      : None.
;
; Opt. Inputs : sc   : STRING giving S/C i.e '1','2','3','4'
;               days : STRARR containing days for processing in form yymmdd.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : REPROCESS_IF : INT indicating how should reprocess existing IF data
;               WEB          : FLAG indicating WEB directory used for output.
;
; Written     :	Version 0.0, 29/1/01
;
; Modified    : Version 0.1, 27/2/01
;                 Added set auto.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text and rcs_batch_process argument list.
;               Version 0.3, 22/03/01
;                 Moved setting of auto out of routine.
;                 Added FILES keyword.
;               Version 0.4, 08/04/01
;                 Added REPROCESS_IF keyword for reprocessing IF data.
;                 Added HOURGLASS.
;               Version 0.5, 24/04/01
;                 Changed rcs_process_if argument list.
;               Version 0.6, 10/05/01
;                 Used bits of reprocess_if flag to select reprocessing options.
;               Version 0.7, 31/05/01
;                 Changed meaning of auto flag.
;               Version 0.8, 18/07/01
;                 Added keyword SC to argument list. Can only process files from a single directory anyway.
;                 Replaced keyword FILES with DAYS.
;               Version 0.9, 12/07/02
;                 Removed ids from argument list.
;               Version 1.0, 20/01/03
;                 Changed so that if no IF data restored will still try to produce plots.
;               Version 1.1, 24/09/03
;                 Changed so that will report if do not need to process data.
;               Version 1.2, 03/10/03
;                 Added WEB keyword.
;
; Version     :	Version 1.2, 03/10/03
;-
;**********************************************************

PRO rcs_batch_if, sc, days, REPROCESS_IF=reprocess_if, WEB=web

  ; NB days can be '' in which case KEYWORD_SET(days) returns 0
  ; this routine returns if days=''
  ; if days not defined then asks user to specify days and sc

  IF N_ELEMENTS(days) EQ 0 THEN rcs_get_days, sc, days

  IF days[0] EQ '' THEN RETURN

  ; check for reprocessing

  IF KEYWORD_SET(reprocess_if) THEN BEGIN

    ; loop through files

    ids = rcs_get_ids()

    ; if interactive then set hourglass

    IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

    FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

      rcs_text, 'REPROCESSING '+days[k], /OVERRIDE

      ; reset IF data (in case already ESPCT data)

      rcs_reset_if

      ; reprocess data

      rcs_reprocess_if, sc, days[k], REPROCESS_IF=reprocess_if

      ; reset IF data

      rcs_reset_if

    ENDFOR

  ENDIF

  ; loop through files

  ids = rcs_get_ids()

  ; if interactive then set hourglass

  IF WIDGET_INFO(ids.base,/VALID_ID) THEN WIDGET_CONTROL, /HOURGLASS

  FOR k = 0, N_ELEMENTS(days)-1 DO BEGIN

    ; check auto mode

    IF (rcs_get_auto() AND 3) NE 0 THEN BEGIN

      rcs_text, 'PROCESSING '+days[k], /OVERRIDE

      ; restore IF files

      rcs_restore_if, ids, sc, days[k]

      ; process data even if no data

      rcs_batch_process, sc, days[k], WEB=web

      ; reset IF data

      rcs_reset_if

    ENDIF ELSE BEGIN

      rcs_text, 'REALTM/SURVEY PLOTS NOT SELECTED for '+days[k], /OVERRIDE

    ENDELSE

  ENDFOR

END
