;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_OUTPUT_DIR
;
; Purpose     :	Sets up output directory name in batch mode.
;
; Explanation : Sets up output directory name in batch mode.
;
; Use         : < output_dir = rcs_batch_output_dir ( root, sc, survey_file, index) >
;
; Inputs      : root        : STRING specifying root output directory  i.e 'PNG'
;               sc          : STRING character giving SC or ''
;               survey_file : STRING survey file name ie ies_survey
;
; Opt. Inputs : index       : STRING giving period within day ie '0', '1', '2' etc
;
; Outputs     : output_dir  : STRING output directory name.
;                             If error returns 0.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 24/1/01
;
; Modified    :	Version 0.1, 08/07/01
;                 Added argument index.
;               Version 0.2, 07/11/03
;                 Modified argument list.
;                 Changed so that -1 no longer acceptable index value.
;                 Changed index argument to string.
;
; Version     :	Version 0.2, 07/11/03
;-
;**********************************************************

FUNCTION rcs_batch_output_dir, root, sc, survey_file, index

  ; get output directory type

  type = strip_dirname(survey_file)

  type = STRMID(type,7,STRPOS(type,'.cfg')-7)

  ; get output directory

  RETURN, rcs_get_subdir(root, sc, type, index)

END
