;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_OUTPUT_FILE
;
; Purpose     :	Sets up output file name in batch mode.
;
; Explanation : Sets up output file name in batch mode.
;
; Use         : < res = rcs_batch_output_file(day, dir, PNG=png, PS=ps, GIF=gif) >
;
; Inputs      : day         : STRING day in form yymmdd.
;               dir         : STRING output directory name
;
; Opt. Inputs : None.
;
; Outputs     : res : INT FLAG indicating whether output file exists already
;
;
; Opt. Outputs: None.
;
; Keywords    : PNG : FLAG indicating png output required.
;               GIF : FLAG indicating gif output required.
;               PS  : FLAG indicating postscript output required.
;
; Written     :	Version 0.0, Martin Carter, RAL, 24/1/01
;
; Modified    :	Version 0.1, 08/07/01
;                 Removed cfg root from file name.
;             	Version 0.2, 07/02/02
;                 Changed to function returning flag if file present.
;             	Version 0.3, 23/07/02
;                 Added source to filename.
;             	Version 0.4, 02/09/03
;                 Changed source IDs.
;
; Version     :	Version 0.4, 02/09/03
;-
;**********************************************************

FUNCTION rcs_batch_output_file, day, dir, PNG=png, PS=ps, GIF=gif

  ; get source

  sss = rcs_get_source()

  ; if source not specified then remove

  IF sss EQ '*' THEN sss = ''

  ; insert underscore

  IF sss NE '' THEN sss = '_' + sss

  ; set up mode

  IF KEYWORD_SET(png) THEN BEGIN

    png = concat_dir ( dir, day + sss + '.png')

    RETURN, file_test(png)

  ENDIF ELSE IF KEYWORD_SET(gif) THEN BEGIN

    gif = concat_dir ( dir, day + sss + '.gif')

    RETURN, file_test(gif)

  ENDIF ELSE IF KEYWORD_SET(ps) THEN BEGIN

    ps = concat_dir ( dir, day + sss + '.ps')

    RETURN, file_test(ps)

  ENDIF

  ; indicate file does not exist

  rcs_message, /IMPLEMENTATION

END
