;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_BATCH_PROCESS
;
; Purpose     :	Handles opening of input data file.
;
; Explanation : Handles opening of input data file.
;                 auto = 0 => auto mode off
;                 auto = 1 => auto mode, generate if data, 4SC, survey and cfg plots
;                 auto = 2 => auto mode, generate if data, 4SC, survey plots.
;                 auto = 3 => auto mode, generate if data, 4SC
;                 auto = 4 => auto mode, generate if data
;
; Use         : < RCS_BATCH_PROCESS, sc, day >
;
; Inputs      : sc   : STRING character containing S/C
;               day  : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : WEB : FLAG indicating WEB directory used for output.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, MKC, 10/12/00
;                 Added PNG format.
;                 Used rcs_batch_output_file.
;               Version 0.2, 14/2/01
;                 Changed routine rcs_get_cfg.
;                 Added rcs_get_auto.
;               Version 0.3, 14/03/01
;                 Changed definitions of auto.
;                 Removed ids from rcs_text and this argument list.
;               Version 0.4, 22/03/01
;                 Moved printout.
;               Version 0.5, 16/05/01
;                 Added IES BM survey plot..
;               Version 0.6, 30/05/01
;                 Changed mechanism for dealing with nonwidget plots.
;               Version 0.7, 31/05/01
;                 Changed meaning of auto flag.
;               Version 0.8, 26/06/01
;                 Added clean survey plot.
;               Version 0.9, 08/07/01
;                 Added part day plots.
;                 Changed output directory structure.
;               Version 1.0, 07/02/02
;                 Changed rcs_batch_output_file to function.
;               Version 1.1, 29/07/02
;                 Separated to rcs_survey_plots and rcs_realtm_plots.
;               Version 1.2, 30/08/03
;                 Changed to RCS environment variables for PNG and GIF.
;               Version 1.3, 03/10/03
;                 Added WEB keyword.
;               Version 1.4, 09/10/03
;                 Used ies get dir.
;               Version 1.5, 07/11/03
;                 Modified rcs realtm plots argument list.
;
; Version     :	Version 1.5, 07/11/03
;-
;**********************************************************

PRO rcs_batch_process, sc, day, WEB=web

  ; check auto mode

  auto = rcs_get_auto()

  IF (auto AND 3) EQ 0 THEN RETURN

  rcs_text, 'GENERATING PLOT(s) FOR S/C ' + sc + ' ' + day

  ; set up type of output required

  IF rcs_version() THEN BEGIN

    root = 'PNG'

    png = 1

  ENDIF ELSE BEGIN

    root = 'GIF'

    gif = 1

  ENDELSE

  ; override if WEB output

  IF KEYWORD_SET(web) THEN root = 'WEB'

  ; check if standard survey plots required

  IF (auto AND 2) NE 0 THEN BEGIN

    ; do standard survey plots

    rcs_survey_plots, root, sc, day, PNG=png, GIF=gif

  ENDIF

  ; NB does not matter that png or gif falg has been overwritten with plot file
  ; since gets overwritten below (just need keyword_set)

  ; check if other survey plots required

  IF (auto AND 1) NE 0 THEN BEGIN

    ; do realtm survey plots

    rcs_realtm_plots, root, sc, day, PNG=png, GIF=gif

  ENDIF

END
