;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CDS_TO_TAI
;
; Purpose     :	Converts from CCSDS Day Segmented (CDS) Time Code format to
;               international atomic time (TAI).
;
; Explanation : CCSDS Day Segmented (CDS) Time Code format is an 8 byte array.
;               Nb ignores the us time field in CCSDS format.
;
; Use         : < result = RCS_CDS_TO_TAI(time) >
;
; Inputs      : time : BYTARR[8] CCSDS Day Segmented (CDS) Time Code format.
;
; Opt. Inputs : None.
;
; Outputs     : result : DOUBLE TAI time.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : DDS.
;
; Prev. Hist. :	Adapted from get_edb.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

FUNCTION rcs_cds_to_tai, time

  ; process CDS time array

  packet_day = time[1]+time[0]*256.d0

  packet_ms = rcs_long(REVERSE(time[2:5]))

  packet_us = rcs_fix(REVERSE(time[6:7]))

  ; set up tai time
  ; NB do not include us since translated into cds tai where only ms supported ?

  tai = packet_day*86400.0d0 + packet_ms*1.0d-3 ; + packet_us*1.0d-6
  
  RETURN, tai

END
