;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CHECK_FILES
;
; Purpose     :	Checks if any files have same date or version as current file.
;
; Explanation : Checks if any files have same date or version as current file.
;
; Use         : < flags = rcs_check_files ( ids, info, current_file) >
;
; Inputs      : ids : STRUCTURE containing widget ids.
;               info : STRUCTURE ARRAY containing file information
;               current_file : STRING name of current file
;
; Opt. Inputs : None.
;
; Outputs     : flags : INTARR[nstreams] flags indicating if streams have the same date as
;                     current file.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    : Version 0.1, 21/1/01
;                 Added ids to argument list and allowed for DAT files.
;                 Changed to check on current stream also.
;               Version 0.2, 09/08/02
;                 Added version to check.
;               Version 0.3, 03/09/03
;                 Changed packet_info.version to packet_info.source and packet_info.cd_version
;
; Version     :	Version 0.3, 03/09/03
;-
;**********************************************************

FUNCTION rcs_check_files, ids, info, current_file

  nstreams = N_ELEMENTS(ids.in)

  flags = INTARR(nstreams)

  inf = rcs_get_packet_info(current_file)

  FOR k = 0, nstreams-1 DO BEGIN

    IF info[k].nfiles GT 0 THEN BEGIN

      infk = rcs_get_packet_info(info[k].file)

      IF infk.time EQ inf.time AND infk.source EQ inf.source AND infk.cd_version EQ inf.cd_version THEN flags[k] = 1

    ENDIF

  ENDFOR

  RETURN, flags

END
