;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CLEAR_FILE
;
; Purpose     : Removes top file on stream.
;
; Explanation : Removes top file on stream.
;
; Use         : <  rcs_clear_file, info, n >
;
; Inputs      : info : STRUCTURE array containing file info
;               n    : INT current file
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE array containing file info updated.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 24/1/01
;                 Uses info structure for storing file info between calls.
;                 Added routines for getting and storing files.
;               Version 0.2, 11/2/01
;                 Removed SILENT keyword.
;               Version 0.3, 13/03/01
;                 Added NOTEXT keyword.
;               Version 0.4, 29/07/02
;                 Removed ids from argument list.
;
; Version     :	Version 0.4, 29/07/02
;-
;**********************************************************

PRO rcs_clear_file, info, n

  ; get current file list

  files = rcs_get_files (n)

  IF N_ELEMENTS(files) GT 1 THEN BEGIN
    files = files[1:*]
  ENDIF ELSE BEGIN
    files = ''
  ENDELSE

  ; save files

  rcs_set_files, n, files, /NOTEXT

  info[n].unit = 0

  info[n].file = files[0]

  IF files[0] EQ '' THEN info[n].nfiles = 0 ELSE info[n].nfiles = N_ELEMENTS(files)

END
