;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CLOSE_FILE
;
; Purpose     :	Handles closing of input data file in batch mode.
;
; Explanation : Handles closing of input data file in batch mode.
;
; Use         : < RCS_CLOSE_FILE, ids, info, n >
;
; Inputs      : ids  : STRUCTURE containing widget info and file type.
;               info : STRUCTURE array containing file info
;               n    : INT current file
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE array containing file info updated.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 11/2/01
;                 Removed silent keyword.
;               Version 0.2, 29/07/02
;                 Removed ids argument list.
;
; Version     :	Version 0.2, 29/07/02
;-
;**********************************************************

PRO rcs_close_file, info, n

  ON_IOERROR, error

  ; close file

  FREE_LUN, info[n].unit

  ; update file display

  rcs_clear_file, info, n

  ; return

  RETURN

  ; error

  error : rcs_message, !ERR_STRING

END
