;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_CORRESPONDING_IF_EXISTS
;
; Purpose     :	Checks if IF data file(s) corresponding to input file name already exist.
;
; Explanation : Checks if IF data file(s) corresponding to input file name already exist.
;               If exists then returns ifname else returns ''.
;
; Use         : < res = RCS_CORRESPONDING_IF_EXISTS (ids, filename, IFNAMES=ifnames) >
;
; Inputs      : filename : STRING name of raw data file
;
; Opt. Inputs : None.
;
; Outputs     : res : TRUE or FALSE depending on whether any IF files exist.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 16/03/01
;                 Modified so that uses existence of IF file to determine if IF data exists.
;                 No longer restores IF data set.
;                 Returns ifnames via argument.
;               Version 0.2, 22/03/01
;                 Modified to use rcs_get_iffiles.
;               Version 0.3, 18/07/01
;                 Modified to use extended IF names.
;               Version 0.4, 13/03/02
;                 Changed routine rcs_if_day name.
;               Version 0.5, 29/07/02
;                 Removed ids from argument list.
;                 Changed name from rcs_if_exists and separated in to new routine.
;               Version 0.6, 08/08/02
;                 Removed IFNAMES KEYWORD.
;                 Added source keyword to rcs_if_exists.
;               Version 0.7, 03/09/03
;                 Changed packet_info.version to packet_info.source and packet_info.cd_version
;
; Version     :	Version 0.7, 03/09/03
;-
;**********************************************************

FUNCTION rcs_corresponding_if_exists, filename

  ; get IF day in form yymmdd

  day = rcs_raw_day(filename)

  ; get packet info for S/C from raw data filename

  packet_info = rcs_get_packet_info(filename)

  ; check if exists

  res = rcs_if_exists(packet_info.sc, day, SOURCE=packet_info.source, CD_VERSION=packet_info.cd_version)

  ; return true or false

  RETURN, res

END
