;**********************************************************
;+
; Project     : CCLUSTER II - RAPID
;
; Name        : RCS_DAT_FILENAME
;
; Purpose     : Extract information from DAT filename.
;
; Explanation : Filename has the form cn_yymmdd_varname.dat
;               where varname is one of 'EDB' or 'HK'.
;
; Use         : <info = rcs_dat_filename(filename) >
;
; Inputs      : filename : STRING filename
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE containing filename info
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     : Version 0.0, 20/1/01
;
; Modified    : Version 0.1, 10/2/01
;                 Changed FILE_NAME_INFO structure.
;               Version 0.2, 18/07/01
;                 Renamed structure returned FILE_NAME_INFO.
;                 Added CDROM version string to FILE_NAME_INFO structure.
;               Version 0.3, 02/09/03
;                 Changed version to source and cd_version..
;
; Version     : Version 0.3, 02/09/03
;-
;**********************************************************

FUNCTION rcs_dat_filename, filename

  ; remove directory

  file = strip_dirname(filename)

  ; decode filename
  ; Filename has the form cn_yymmdd_varname.dat

  ; conver to uppercase

  file = STRUPCASE(file)

  ; strip off .DAT extension

  pos = STRPOS(file,'.DAT')

  IF pos LT 11 THEN BEGIN

    rcs_message, 'INVALID FILENAME : '+filename

  ENDIF

  file = STRMID(file,0,pos)

  ; get info

  sc = STRMID(file,1,1)

  var_name = STRMID(file,10,pos-10)

  ; set type

  CASE var_name OF
    'EDB' : type = ''
    'HK' : type = 'CCSHK'
    ELSE : rcs_message, 'INVALID FILE VAR_NAME : '+var_name
  ENDCASE

  ; decode time

  yy = STRMID(file,3,2)

  mm = STRMID(file,5,2)

  dd = STRMID(file,7,2)

  ; check valid
  ; allow non-robust code for now

  year = FIX(yy)

  year = year+1900

  IF year LT 1950 THEN year = year + 100

  month = FIX(mm)

  day = FIX(dd)

  time = anytim2tai({YEAR:year,MONTH:month,DAY:day,HOUR:0,MINUTE:0,SECOND:0,MILLISECOND:0})

  source = rcs_get_source()

  cd_version = 'a'

  ; return file name information

  RETURN, {FILE_NAME_INFO, name:filename, time:time, type:type, sc:sc, source:source, cd_version:cd_version}

END
