;**********************************************************
;+
; Project     : CCLUSTER II - RAPID
;
; Name        : RCS_DDS_FILENAME
;
; Purpose     : Extract information from DDS filename.
;
; Explanation : Filename has the form yymmddst.nvc.
;
; Use         : <info = rcs_dds_filename(filename) >
;
; Inputs      : filename : STRING filename form : yymmddst.nvc
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE containignn filename info
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     : Version 0.0, 17/9/00
;
; Modified    : Version 0.1, 10/2/01
;                 Changed FILE_NAME_INFO structure.
;               Version 0.2, 18/07/01
;                 Added CDROM version string to FILE_NAME_INFO structure.
;               Version 0.3, 02/09/03
;                 Changed version to source and cd_version..
;
; Version     : Version 0.3, 02/09/03
;-
;**********************************************************

FUNCTION rcs_dds_filename, filename

  ; remove directory

  file = strip_dirname(filename)

  ; check filename has expected form : yymmddst.nvc

  IF (STRLEN(file) NE 12) OR (STRPOS(file,'.') NE 8) THEN RETURN, 0

  ; decode filename

  yy = STRMID(file,0,2)

  mm = STRMID(file,2,2)

  dd = STRMID(file,4,2)

  s = STRUPCASE(STRMID(file,6,1))

  t = STRUPCASE(STRMID(file,7,1))

  n = STRUPCASE(STRMID(file,9,1))

  v = STRUPCASE(STRMID(file,10,1))

  c = STRUPCASE(STRMID(file,11,1))

  ; check valid
  ; allow non-robust code for now

  year = FIX(yy)

  year = year+1900

  IF year LT 1950 THEN year = year + 100

  month = FIX(mm)

  day = FIX(dd)

  time = anytim2tai({YEAR:year,MONTH:month,DAY:day,HOUR:0,MINUTE:0,SECOND:0,MILLISECOND:0})

  IF s NE 'R' THEN RETURN, 0

  CASE t OF
      'N' : type = 'CCSNM'
      'B' : type = 'CCSBM'
      'H' : type = 'CCSHK'
      ELSE : RETURN, 0
  ENDCASE

  cdrom = FIX(n)

  sc = c

  source = rcs_get_source()

  cd_version = STRLOWCASE(v)

  ; return file name information

  RETURN, {FILE_NAME_INFO, name:filename, time:time, type:type, sc:sc, source:source, cd_version:cd_version}

END
