;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_DO_COMMON
;
; Purpose     :
;
; Explanation :
;
; Use         : < RCS_DO_COMMON, dat, head, data, headers, new >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     :
;
; Opt. Outputs: None.
;
; Keywords    : RESET : FLAG indicating reset.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 17/9/00
;-
;**********************************************************

PRO rcs_do_common, dat, head, data, headers, new

  ; dynamically create header structure

  head_struct = create_struct(name=TAG_NAMES(head,/STRUCTURE_NAME)+'_INDEX',$
                    'header', head, 'index', 0L)

  ; set local variables

  dat_size = N_ELEMENTS(dat)
  IF KEYWORD_SET(data) THEN data_size = N_ELEMENTS(data) ELSE data_size = 0

  ; set headers

  head_struct.index = data_size

  ; increment arrays

  IF KEYWORD_SET(headers) THEN BEGIN

    ; check same structures

    IF TAG_NAMES(headers,/STRUCTURE_NAME) EQ TAG_NAMES(head_struct,/STRUCTURE_NAME) THEN BEGIN

      headers = [TEMPORARY(headers),head_struct]

      ; NB data=0 => no data

      IF KEYWORD_SET(data) THEN data = [TEMPORARY(data),dat] ELSE data = dat

    ENDIF ELSE BEGIN

      headers = head_struct

      data = dat

    ENDELSE

  ENDIF ELSE BEGIN

    headers = head_struct

    data = dat

  ENDELSE

  ; increment new data

  new = new + dat_size

END

