;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_DAT
;
; Purpose     :	Unpacks RAPID DAT data.
;
; Explanation : Reads header from each file stream.
;               NB headers stored.
;               Finds earliest header.
;               Extracts data to COMMON blocks.
;               Returns flag indicating result.
;
; Use         : < result = RCS_GET_DAT(ids, info, n) >
;
; Inputs      : ids  : STRUCTURE containing widget IDs
;               info : STRUCTURE array containing file info
;               n    : INT index into info for current file
;
; Opt. Inputs : None.
;
; Outputs     :    0 : if more data needed
;                  1 : if acquired sufficient data
;                  2 : next file needed
;                  3 : all file ends reached or earliest header file end reached
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 19/1/01
;
; Modified    :	Version 0.1, 12/2/01
;                 Removed SILENT and BATCH keywords.
;                 Changed to silent routine.
;               Version 0.2, 21/2/01
;                 Renamed batch --> auto
;
; Version     :	Version 0.2, 21/2/01
;-
;**********************************************************

FUNCTION rcs_get_dat, ids, info, n

  ; Require :
  ;   if any file blocked and more than 1 file in list then should return and open next file
  ;   if some blocked but not others then carry on
  ;   if all blocked then should return

  ; get headers for each file

  n = -1
  header = 0

  FOR k = 0, N_ELEMENTS(ids.in)-1 DO BEGIN

    ; get packet header
    ; if available then check if earliest header or not and update earliest if so
    ; if not available then if more files available for this stream return 2
    ; else proceed to next stream

    theader = rcs_get_dat_header ( ids, info, k)

    IF KEYWORD_SET(theader) THEN BEGIN

      IF KEYWORD_SET(header) THEN BEGIN

        IF theader.time LT header.time THEN BEGIN

          ; replace header

          header = theader

          n = k

        ENDIF

      ENDIF ELSE BEGIN

        header = theader

        n = k

      ENDELSE

    ENDIF ELSE IF KEYWORD_SET(rcs_get_auto()) THEN BEGIN

      ; either
      ; 1) end of file
      ; 2) no file open for this date (though maybe later files)
      ; if 1 then close file in rcs_get_data
      ; if 2 then continue

      IF info[k].unit NE 0 THEN BEGIN

        n = k

        RETURN, 2

      ENDIF

    ENDIF ELSE IF info[k].nfiles GT 1 THEN BEGIN

      ; if multiple files defined this allows next file to be read
      ; if only single file then stays open waiting for more data to be appended

      n = k

      RETURN, 2

    ENDIF

  ENDFOR

  ; if no headers available and no more files to open return 3

  IF NOT KEYWORD_SET(header) THEN RETURN, 3

  ; nb passed by reference

  result = rcs_get_dat_data( ids, info, n, header)

  RETURN, result

END
