;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_DAYS
;
; Purpose     :	Allows user to select days and sc.
;
; Explanation : Allows user to select days and sc.
;               Days are extracted from fiels selected.
;               S/C is extracted from first file selected.
;
; Use         : < rcs_get_days, sc, days >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : sc     : STRING defining S/C :'1','2','3','4'
;               days   : STRARR output list of days, yymmdd.
;
; Opt. Outputs: None.
;
; Keywords    : TITLE  : STRING pickfile widget title.
;               SINGLE : FLAG indicating only one file selection allowed.
;               FILES  : STRARR files corresponding to days
;               SCI    : FLAG indicating SCI files rather than IF files.

; Written     :	Version 0.0, Martin Carter, RAL, 22/03/01
;
; Modified    : Version 0.1, 25/07/01
;                 Changed output to days.
;               Version 0.2, 07/09/01
;                 Fixed bug with single keyword.
;               Version 0.3, 11/10/01
;                 Fixed another bug with single keyword.
;               Version 0.4, 13/03/02
;                 Added rcs_ifname_day.
;               Version 0.5, 04/07/02
;                 Added SCI files.
;               Version 0.6, 11/03/03
;                 Added postfix argument to aloow gzipped files.
;               Version 0.7, 02/09/03
;                 Used rcs_if_filter.
;               Version 0.8, 08/10/03
;                 Used ies get dir.
;
; Version     :	Version 0.8, 08/10/03
;-
;**********************************************************

PRO rcs_get_days, sc, days, TITLE=title, SINGLE=single, FILES=files, SCI=sci

  sc = ''

  days = ''

  IF KEYWORD_SET(sci) THEN BEGIN

    IF NOT KEYWORD_SET(title) THEN title = 'Select SCI files for processing or CANCEL'

    ; get SCI files

    filter = rcs_sciname('*', '*', '*', '*', /FILE)

    files = ies_pickfile ( PATH=ies_get_Dir('DATA',/RAPID), MULTIPLE= NOT KEYWORD_SET(single), COUNT=count, $
                           TITLE=title,/MUST_EXIST, $
                            FILTER=filter  )

    IF count EQ 0 THEN BEGIN

      rcs_text, 'NO SCI FILES SELECTED OF TYPE : '+filter, /OVERRIDE

      RETURN

    ENDIF

    sc = rcs_sciname_sc(files[0])

    ; select and sort days, format ymmdd

    days = rcs_sciname_day(files)

  ENDIF ELSE BEGIN

    IF NOT KEYWORD_SET(title) THEN title = 'Select IF files for processing or CANCEL'

    ; get IF files

    filter = rcs_if_filter(SOURCE=rcs_get_source())

    files = ies_pickfile ( PATH=ies_get_dir('IF',/RAPID), MULTIPLE= NOT KEYWORD_SET(single), COUNT=count, $
                           TITLE=title,/MUST_EXIST, $
                            FILTER=filter  )

    IF count EQ 0 THEN BEGIN

      rcs_text, 'NO IF FILES SELECTED OF TYPE : '+filter, /OVERRIDE

      RETURN

    ENDIF

    sc = rcs_ifname_sc(files[0])

    ; select and sort days, yymmdd

    days = rcs_ifname_day(files)

  ENDELSE

  IF KEYWORD_SET(single) THEN BEGIN

    days = days[0]

    files = files[0]

    RETURN

  ENDIF

  list = rcs_sort_days(days)

  days = days[list]

  files = files[list]

END
