;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_FILES
;
; Purpose     :	Gets current files.
;
; Explanation : Gets current files.
;
; Use         : < files = RCS_GET_FILES(n) >
;
; Inputs      : n    : INT defining file stream.
;
; Opt. Inputs : None.
;
; Outputs     : files : STRARR(*) array containing file names.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 26/1/01
;
; Modified    : Version 0.1, 11/2/01
;                 Changed to using COMMON block for files.
;
; Version     :	Version 0.1, 11/2/01
;-
;**********************************************************

FUNCTION rcs_get_files, n

  COMMON rcs_in_files_local, files_0, files_1, files_2

  ; previously used VALUE to store file names directly
  ; but need silent option where file names not updated
  ; directly on widget
  ; then used UVALUES but now need batch mode where no widgets

  CASE n[0] OF
    0 : files = files_0
    1 : files = files_1
    2 : files = files_2
    ELSE : rcs_message, 'IMPLENTATION ERROR'
  ENDCASE

  ; return file names

  RETURN, files

END
