;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_INFO
;
; Purpose     :	Gets information about current files.
;
; Explanation : Gets information about current files.
;
; Use         : < info = RCS_GET_INFO() >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE array containing file info.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 13/12/00
;                 Made info contain previous time explicitly.
;                 Uses info structure for storing file info between calls.
;                 Stored frame counter for DAT data.
;                 Added routine to retrieve files.
;               Version 0.2, 12/2/01
;                 Moved to common block.
;               Version 0.3, 27/07/01
;                 Protected output.
;
; Version     :	Version 0.3, 27/07/01
;-
;**********************************************************

FUNCTION rcs_get_info

  COMMON rcs_info_local, info

  IF NOT KEYWORD_SET(info) THEN BEGIN

    ids = rcs_get_ids()

    ; set up structure array to store info about current state of each data type
    ; if DAT data keep track of frame counter

    IF ids.type EQ 'DAT' THEN $
      info = REPLICATE({DAT_INFO, unit:0L, file:'', nfiles:0, bytes:0L, previous_time:0.0D0, previous_fc:0}, N_ELEMENTS(ids.in) ) $
    ELSE $
      info = REPLICATE({INFO, unit:0L, file:'', nfiles:0, bytes:0L, previous_time:0.0D0}, N_ELEMENTS(ids.in) )

    ; loop through file streams

    FOR k=0, N_ELEMENTS(ids.in)-1 DO BEGIN

      files = rcs_get_files (k)

      info[k].file = files[0]

      IF files[0] EQ '' THEN info[k].nfiles = 0 ELSE info[k].nfiles = N_ELEMENTS(files)

    ENDFOR

  ENDIF

  temp = info

  RETURN, temp

END
