;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_PACKET_INFO
;
; Purpose     :	Gets packet_info for input data.
;
; Explanation : Gets packet_info for input data.
;
; Use         : < packet_info = rcs_get_packet_info(input_file) >
;
; Inputs      : input_file : STRING input file name
;                 For DDS file must have form yymmddst.nvc
;
; Opt. Inputs : None.
;
; Outputs     : packet_info : STRUCTURE containing file info
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 15/1/01
;                 Added rcs_sc_selection.
;                 Added DAT file check.
;               Version 0.2, 12/2/01
;                 Changed so does not use sc slection.
;                 Use file extension to determine if dat file.
;                 Remove ids from argument list.
;               Version 0.3, 2/3/01
;                 Added rcs_chk_filename.
;               Version 0.4, 12/3/02
;                 Renamed rcs_chk_filename.
;
; Version     :	Version 0.4, 12/3/02
;-
;**********************************************************

FUNCTION rcs_get_packet_info, input_file

  ; check file type

  CASE rcs_raw_check(input_file) OF

    0 : RETURN, rcs_dds_filename(input_file)

    1 : RETURN, rcs_dat_filename(input_file)

  ENDCASE

END
