;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_PREVIOUS
;
; Purpose     :	Gets previous info structure.
;
; Explanation : Gets previous info structure.
;
; Use         : < previous = RCS_GET_PREVIOUS(/SC) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : previous : STRUCTURE giving info
;
; Opt. Outputs: None.
;
; Keywords    : SC : Flag indicating science stream
;               HK : Flag indicating housekeeping stream
;
; Written     :	Version 0.0, 12/2/01
;
; Modified    : Version 0.1, 27/07/01
;                 Protected output.
;
; Version     :	Version 0.1, 27/07/01
;-
;**********************************************************

FUNCTION rcs_get_previous, SC=sc, HK=hk

  COMMON rcs_previous_local, previous_sc, previous_hk

  ; get previous info

  IF KEYWORD_SET(sc) THEN BEGIN

    ; initialize COMMON variables
    ; ie -1 indicates EDB extraction not started (0 is valid)

    IF NOT KEYWORD_SET(previous_sc) THEN previous_sc = {subc:-1,type:-1,pos:0L}

    temp = previous_sc

    RETURN, temp

  ENDIF ELSE IF KEYWORD_SET(hk) THEN BEGIN

    ; initialize COMMON variables
    ; ie -1 indicates EDB extraction not started (0 is valid)

    IF NOT KEYWORD_SET(previous_hk) THEN previous_hk = {fc:-1, time:0.0d0}

    temp = previous_hk

    RETURN, temp

  ENDIF ELSE rcs_message,/IMPLEMENTATION

END
