;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_SCNAME
;
; Purpose     :	Constructs SC name.
;
; Explanation : Constructs SC name.
;
; Use         : < scname = RCS_GET_SCNAME( sc ) >
;
; Inputs      : sc : STRING character indicating S/C.
;                    If '' then returns 'RAPID'.
;
; Opt. Inputs : None.
;
; Outputs     : scname : STRING S/C file name
;
; Opt. Outputs: None.
;
; Keywords    :
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    : Version 0.1, 07/11/03
;                 Modified to return 'RAPID' if sc not set.
;
; Version     :	Version 0.1, 07/11/03
;-
;**********************************************************

FUNCTION rcs_get_scname, sc

  IF NOT KEYWORD_SET(sc) THEN RETURN, 'RAPID' ELSE RETURN, 'RAPID_'+sc

END
