;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GET_TIMER
;
; Purpose     :	Adapts time between testing for new data.
;
; Explanation : Deals with events from the RCS_IN widget and uses TIMER events to trigger data extraction
;               from input data file.
;
; Use         : < rcs_in_event, event >
;
; Inputs      : event : EVENT structure from RCS_IN widget or TIMER.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : RCS_IN.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

FUNCTION rcs_get_timer, blocked

  COMMON local_timer_block, current_timer

  IF N_ELEMENTS(current_timer) EQ 0 THEN current_timer = 1.0

  IF blocked THEN BEGIN

    current_timer = 1.0 ; time between retests is 1 s

  ENDIF ELSE BEGIN

    current_timer = 0.001 ; time between retests is 1 ms

  ENDELSE

  RETURN, current_timer

END
