;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_GSEOS_HEADER
;
; Purpose     :	Removes and decodes extra GSEOS header from GSEOS block body.
;
; Explanation : Removes 14 byte header associated with each GSEOS block :
;               "In the Block Body it is the item 'abyData' to extract. This data doesn't
;                contain only the EDB-data, it consist of a 14 Byte header (bytes 0 to 13)
;                for the CCSNM item and 660 bytes of EDB-data (bytes 14-673)."
;               syncstop block do not have this header
;               does EDB, HK data  have this header or only CCS* ?
;
; Use         : < header = RCS_DO_GSEOS_HEADER(type, data) >
;
; Inputs      : type : STRING  STRING one of 'CCSNM', 'CCSBM1', CCSHK', ('HK', 'EDB')
;               data : BYTARR containing block body.
;                      Returned with header removed where appropriate.
;
; Opt. Inputs : None.
;
; Outputs     : header : STRUCTURE containing header info
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : GSEOS.
;
; Prev. Hist. :	Adapted from read_filter.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    : Version 0.1, 10/2/01
;                 Changed FILE_NAME_INFO structure.
;                 Changed PACKET_HEADER structure.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text argument list.
;               Version 0.3, 18/07/01
;                 Added version string to FILE_NAME_INFO structure.
;               Version 0.4, 02/09/03
;                 Changed version to source and cd_version..
;
; Version     : Version 0.4, 02/09/03
;-
;**********************************************************

FUNCTION rcs_gseos_header, ids, type, time, data, filename

  ; remove extra header

  IF N_ELEMENTS(data) GT 14 THEN BEGIN
    IF type NE 'EDB' AND type NE 'HK' AND type NE 'MESSAGE' THEN data = data[14:*]
  ENDIF ELSE BEGIN
    rcs_text, 'INVALID HEADER SIZE : '+type
  ENDELSE

  ; decode header

  ; header format unknown at present
  ; first 8 bytes are not CDS time

  source = rcs_get_source()

  cd_version = 'a'

  info = {FILE_NAME_INFO, name:filename, time:0.0d0, type:type, sc:rcs_sc_selection(ids), source:source, cd_version:cd_version}

  ; return

  RETURN, {PACKET_HEADER, info:info, time:time, length:N_ELEMENTS(data)}

END
