;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IF_EXISTS
;
; Purpose     :	Checks if IF data file(s) already exist.
;
; Explanation : Checks if IF data file(s) already exist.
;               If exists then 1 else returns 0.
;
; Use         : < res = RCS_IF_EXISTS (ids, filename, IFNAMES=ifnames) >
;
; Inputs      : sc  : STRING character giving sc
;               day : STRING day in form yymmdd
;
; Opt. Inputs : None.
;
; Outputs     : res : TRUE or FALSE depending on whether any IF files exist.
;
; Opt. Outputs: None.
;
; Keywords    : IFNAMES    : STRARR IF file names.
;               SOURCE     : STRING sourceletter filter
;               CD_VERSION : STRING cd version ie 'a'
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 16/03/01
;                 Modified so that uses existence of IF file to determine if IF data exists.
;                 No longer restores IF data set.
;                 Returns ifnames via argument.
;               Version 0.2, 22/03/01
;                 Modified to use rcs_get_iffiles.
;               Version 0.3, 18/07/01
;                 Modified to use extended IF names.
;               Version 0.4, 13/03/02
;                 Changed routine rcs_if_day name.
;               Version 0.5, 29/07/02
;                 Removed ids from argument list.
;                 Separated into new routine.
;               Version 0.6, 08/08/02
;                 Added source version to filter and KEYWORD.
;               Version 0.7, 03/09/03
;                 Changed default behaviour of rcs_get_iffiles.
;                 NB previously used KEYWORD_SET now uses N_ELEMENTS eq 0 so will behave differently if source=''
;                 but if source='' then sets COMMON source='' anyway.
;                 Changed so that should not use combined source and cd_version.
;
; Version     :	Version 0.7, 03/09/03
;-
;**********************************************************

FUNCTION rcs_if_exists, sc, day, IFNAMES=ifnames, SOURCE=source, CD_VERSION=cd_version

  ; get ifnames

  ifnames = rcs_get_iffiles ( sc, COUNT=count, DAY=day, SOURCE=source, CD_VERSION=cd_version)

  ; return true or false

  RETURN, count GT 0

END
