;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IN_DAY
;
; Purpose     :	Returns day in form yymmdd.
;
; Explanation : Returns day in form yymmdd.
;
; Use         : < day = rcs_in_day(ids, input_file) >
;
; Inputs      : ids  : STRUCTURE containing widget info
;               input_file : STRING input file
;
; Opt. Inputs : None.
;
; Outputs     : day : STRING day in form yymmdd.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 30/1/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 30/1/01
;-
;**********************************************************

FUNCTION rcs_in_day, ids, input_file

  ; extract day from input file
  ; check if dat or dds file

  ifile = strip_dirname(input_file)

  IF ids.type EQ 'DDS' THEN day = STRMID(ifile,0,6) ELSE day = STRMID(ifile,3,6)

  RETURN, day

END
