;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_IN_STATE
;
; Purpose     :	Displays current state of RCS_IN process.
;
; Use         : < rcs_in_state, ids >
;
; Inputs      : ids : structure containing widget ids for display
;
; Opt. Inputs : None.
;
; Outputs     : None
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	Version 0.1, 10/2/01
;                 Changed silent flag to common block.
;               Version 0.2, 13/03/01
;                 Changed use of silent flag.
;
; Version     :	Version 0.2, 13/03/01
;-
;**********************************************************

PRO rcs_in_state, ids

  ; global common blocks

  COMMON rcssc_data_block, rcssc_data, rcssc_headers

  COMMON rcshk_data_block, rcshk_data, rcshk_headers

  ; check silent flag

  IF rcs_get_silent() THEN RETURN

  IF NOT WIDGET_INFO(ids.sc,/VALID_ID) THEN RETURN

  IF KEYWORD_SET(rcssc_data) THEN rcssc_size = N_ELEMENTS(rcssc_data) ELSE rcssc_size=0

  IF KEYWORD_SET(rcshk_data) THEN rcshk_size = N_ELEMENTS(rcshk_data) ELSE rcshk_size=0

  WIDGET_CONTROL, ids.sc, SET_VALUE=rcs_strtrim(rcssc_size)

  WIDGET_CONTROL, ids.hk, SET_VALUE=rcs_strtrim(rcshk_size)

END
