;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_NEXT_FILE
;
; Purpose     :	Handles opening of input data file.
;
; Explanation : Handles opening of input data file.
;
; Use         : < RCS_NEXT_FILE, ids, info, n >
;
; Inputs      : ids  : STRUCTURE containing widget info and file type.
;               info : STRUCTURE array containing file info
;               n    : INT current file
;
; Opt. Inputs : None.
;
; Outputs     : info : STRUCTURE array containing file info updated.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 19/1/01
;                 Used new ids.type tag.
;                 Uses info structure for storing file info between calls.
;               Version 0.2, 14/03/01
;                 Removed ids from rcs_text and rcs_gseos_file_header argument list.
;               Version 0.3, 17/07/03
;                 Allowed compressed file to be used.
;               Version 0.4, 31/07/03
;                 Added QUIET flag to rcs_open_file
;
; Version     :	Version 0.4, 31/07/03
;-
;**********************************************************

PRO rcs_next_file, ids, info, n

  ON_IOERROR, error

  ; check if no files left

  IF info[n].nfiles EQ 0 THEN RETURN

  ; open next file

  rcs_text, 'OPENING INPUT FILE : '+info[n].file, /OVERRIDE

  IF NOT rcs_open_file(info[n].file, unit, /QUIET) THEN rcs_message, 'ERROR OPENING FILE'

  ; set unit

  info[n].unit = unit

  IF ids.type EQ 'GSEOS' THEN rcs_gseos_file_header, info[n].unit

  ; return

  RETURN

  ; error

  error : rcs_message, !ERR_STRING

END
