;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_NEXT_FILES
;
; Purpose     :	Handles opening of next files in batch mode.
;
; Explanation : Handles opening of next files in batch mode.
;
; Use         : < res = RCS_NEXT_FILES (ids, info) >
;
; Inputs      : ids  : STRUCTURE containing widget info and file type.
;               info : STRUCTURE array containing file info
;
; Opt. Inputs : None.
;
; Outputs     : res : INT result :
;                      0 : blocked : no more files
;                      1 : unblocked : data processed
;                      2 ; unblocked : files open or opened new files
;
; Opt. Outputs: None.
;
; Keywords    : WEB : FLAG indicating WEB directory used for output.

;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 26/1/01
;                 Modified to allow control to return to xmanager.
;                 Added SILENT keyword.
;                 Added GRAPH keyword.
;               Version 0.2, 11/2/01
;                 Removed silent keyword.
;                 Removed GRAPH keyword.
;               Version 0.3, 14/03/01
;                 Added FORCE.
;                 Removed ids from rcs_batch_process argument list.
;               Version 0.4, 16/03/01
;                 Changed rcs_if_exists.
;                 Added skip of restore IF files if not needed.
;               Version 0.5, 31/05/01
;                 Changed meaning of auto flag.
;               Version 0.6, 18/07/01
;                 Allowed extended IF file names.
;               Version 0.7, 30/08/01
;                 Changed so that does not produce plots if IF files already exist.
;               Version 0.8, 29/07/02
;                 Removed ids from some argument lists.
;               Version 0.9, 03/10/03
;                 Added WEB keyword.
;
; Version     :	Version 0.9, 03/10/03
;-
;**********************************************************

FUNCTION rcs_next_files, ids, info, WEB=web

  ON_IOERROR, error

  ; if any files open then return
  ; if stopped in auto mode then can restart using AUTO command

  dummy = WHERE(info.unit NE 0, count)

  IF count NE 0 THEN RETURN, 2

  ; open new files
  ; get list of streams with next files

  list = WHERE(info.nfiles GT 0, count)

  IF count EQ 0 THEN RETURN, 0

  ; get list of times of next files

  times = DBLARR(count)

  FOR k = 0, count-1 DO BEGIN

    inf = rcs_get_packet_info (info[list[k]].file )

    times[k] = inf.time

  ENDFOR

  ; get list of streams with equal earliest time

  elist = WHERE(times EQ MIN(times), ecount)

  ; check if IF data already exists
  ; whilst IF files exist does not allow interruption

  file = info[list[elist[0]]].file

  IF rcs_get_force() THEN BEGIN

    ; open files with earliest times

    FOR k = 0, ecount-1 DO rcs_next_file, ids, info, list[elist[k]]

    ; return

    RETURN, 2

  ENDIF ELSE IF rcs_corresponding_if_exists(file) THEN BEGIN

    ; check auto mode

    IF 0 THEN BEGIN
    ;IF (rcs_get_auto() AND 1) NE 0 THEN BEGIN

      ; get sc, day

      sc = rcs_in_sc(file)

      day = rcs_in_day(ids,file)

      ; restore IF data sets

      rcs_restore_if, ids, sc, day

      ; update state

      rcs_extract_state, ids

      ; process data

      rcs_batch_process, sc, day, WEB=web

    ENDIF

    ; reset IF data

    rcs_reset_if

    ; update file list

    FOR k = 0, ecount-1 DO rcs_clear_file, info, list[elist[k]]

    RETURN, 1

  ENDIF ELSE BEGIN

    ; open files with earliest times

    FOR k = 0, ecount-1 DO rcs_next_file, ids, info, list[elist[k]]

    ; return

    RETURN, 2

  ENDELSE

  ; error

  error : rcs_message, !ERR_STRING

END
