;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RAW_DAY
;
; Purpose     :	Gets day from input data file name in form yymmdd.
;
; Explanation : Gets day from input data file name in form yymmdd.
;
; Use         : < day= RCS_RAW_DAY( filename ) >
;
; Inputs      : filename : STRING name of raw data file
;
; Opt. Inputs : None.
;
; Outputs     : name : STRING IF day
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 2/3/01
;                 Allowed DAT filenames.
;               Version 0.2, 12/3/02
;                 Renamed rcs_chk_filename.
;                 Renamed this routine.
;
; Version     :	Version 0.2, 12/3/02
;-
;**********************************************************

FUNCTION rcs_raw_day, filename

  name = strip_dirname(filename)

  CASE rcs_raw_check(filename) OF

    0 : RETURN, STRMID(name,0,6)

    1 : RETURN, STRMID(name,3,6)

  ENDCASE

END
