;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_REALTM_PLOTS
;
; Purpose     :	Does realtm survey plots.
;
; Explanation : Does realtm survey plots.
;
; Use         : < RCS_REALTM_PLOTS, root, sc, day >
;
; Inputs      : root : STRING specifying root output directory  i.e 'PNG'
;               sc   : STRING character giving SC or ''
;               day  : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : PNG : Flag indicating PNG output
;               GIF : Flag indicating GIF output
;
; Written     :	Version 0.0, Martin Carter, RAL, 29/07/02
;                 Separated from rcs batch process.
;
; Modified    : Version 0.1, 09/10/03
;                 Used ies get dir.
;               Version 0.2, 07/11/03
;                 Modified argument list.
;
; Version     :	Version 0.2, 07/11/03
;-
;**********************************************************

PRO rcs_realtm_plots, root, sc, day, PNG=png, GIF=gif

  ; get list of survey plots

  survey_list = FINDFILE(concat_dir(ies_get_dir('CFG',/RAPID),'survey_*.cfg'), COUNT=count)

  ; loop through list

  FOR k = 0, count-1 DO BEGIN

    ; restore cfg file

    output_info = rcs_restore_cfg(FILE=survey_list[k])

    IF NOT KEYWORD_SET(output_info) THEN rcs_message, /IMPLEMENTATION

    ; check if hist output

    IF output_info.hist THEN BEGIN

      ; create dummy widget widget

      widget_ids = rcs_widget(output_info, /NONWIDGET)

      ; set up output file name

      subdir = rcs_batch_output_dir(root, sc, survey_list[k])

      IF NOT KEYWORD_SET(subdir) THEN RETURN

      dummy = rcs_batch_output_file(day, subdir, PNG=png, GIF=gif)

      rcs_get_positions, positions

      ; do plot

      dummy = rcs_widget_update(widget_ids,output_info,positions,PNG=png,GIF=gif)

    ENDIF ELSE BEGIN

      day_start = anytim2tai(STRMID(day,0,2)+'/'+STRMID(day,2,2)+'/'+STRMID(day,4,2))

      FOR q = 0, rcs_get_nplots() DO BEGIN

        IF q EQ 0 THEN BEGIN

          t0 = day_start
          t1 = day_start + 86400L

        ENDIF ELSE BEGIN

          duration = 86400L/rcs_get_nplots()
          t0 = day_start + (q-1)*duration
          t1 = day_start + q*duration

        ENDELSE

        ; create dummy panel widget

        panel_ids = rcs_panel(output_info, /NONWIDGET)

        ; set up output file name

        subdir = rcs_batch_output_dir(root, sc, survey_list[k], rcs_strtrim(q))

        IF NOT KEYWORD_SET(subdir) THEN RETURN

        dummy = rcs_batch_output_file(day, subdir, PNG=png, GIF=gif)

        rcs_get_positions, positions

        ; do plot

        dummy = rcs_panel_update(panel_ids,output_info,positions, PNG=png, GIF=gif, TRANGE=[t0,t1] )

      ENDFOR

    ENDELSE

  ENDFOR

END
