;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESET_DISPLAY
;
; Purpose     : Resets values and uvalues in rcs_in display.
;
; Explanation : Resets values and uvalues in rcs_in display.
;
; Use         : <  rcs_reset_display, ids >
;
; Inputs      : ids : STRUCTURE containing widget info and file type.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 24/1/01
;                 Changed to info structure.
;               Version 0.2, 11/2/01
;                 Moved packet_header to COMMON.
;                 Added valid ID check.
;            	Version 0.3, 22/07/02
;                 Allowed no .in tag.
;
; Version     :	Version 0.3, 22/07/02
;-
;**********************************************************

PRO rcs_reset_display, ids

  IF ies_tag_exists(ids,'IN') THEN BEGIN

    FOR k=0, N_ELEMENTS(ids.in)-1 DO BEGIN

      ; reset bytes read

      IF WIDGET_INFO(ids.in[k].bytes,/VALID_ID) THEN $
        WIDGET_CONTROL, ids.in[k].bytes, SET_VALUE=''

      ; reset display

      IF WIDGET_INFO(ids.in[k].time,/VALID_ID) THEN $
        WIDGET_CONTROL, ids.in[k].time, SET_VALUE=''

      ; reset any stored packet header

      rcs_set_header, k, 0

    ENDFOR

  ENDIF

END
