;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_RESET_FILES
;
; Purpose     : Resets files.
;
; Explanation : Resets files.
;
; Use         : <  rcs_reset_files, ids >
;
; Inputs      : ids : STRUCTURE containing widget info and file type.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 15/1/00
;                 Changed to info structure.
;            	Version 0.2, 22/07/02
;                 Allowed no .in tag.
;
; Version     :	Version 0.2, 22/07/02
;-
;**********************************************************

PRO rcs_reset_files, ids

  IF ies_tag_exists(ids,'IN') THEN BEGIN

    ; get info structure unit and zero

    info = rcs_get_info()

    rcs_set_info, 0

    FOR k=0, N_ELEMENTS(ids.in)-1 DO BEGIN

      IF KEYWORD_SET(info) THEN BEGIN

        ; close file

        IF KEYWORD_SET(info[k].unit) THEN FREE_LUN, info[k].unit

      ENDIF

      rcs_set_files, k, ''

    ENDFOR

  ENDIF

END
