;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SAVE_CM
;
; Purpose     :	Saves current COMMON block data to IDL save set.
;
; Use         : < rcs_save_cm, ids >
;
; Inputs      : ids : structure containing widget ids for display
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :
;
; Common      : rcssc_data_block, rcshk_data_block.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : RCS_IN
;
; Prev. Hist. :	Adapted from analyze.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/1/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 8/1/00
;-
;**********************************************************

PRO rcs_save_cm, ids

  ; global common blocks

  COMMON rcssc_data_block, rcssc_data, rcssc_headers

  COMMON rcshk_data_block, rcshk_data, rcshk_headers

  file = ies_pickfile ( COUNT=count, TITLE='Select file for saving SC/HK COMMON blocks or CANCEL' )

  ; deal with CANCEL

  IF count EQ 0 THEN RETURN

  SAVE, rcssc_data, rcssc_headers, rcshk_data, rcshk_headers, FILE=file[0]

END