;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SC_SELECTION
;
; Purpose     :	Gets S/C selected in droplist.
;
; Explanation : Gets S/C selected in droplist.
;
; Use         : < sc = rcs_sc_selection(ids) >
;
; Inputs      : ids  : STRUCTURE containing widget IDs
;
; Opt. Inputs : None.
;
; Outputs     : sc : STRING single character reprtesenting S/C.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 15/1/01
;
; Modified    :	None.
;
; Version     :	Version 0.0, 15/1/01
;-
;**********************************************************

FUNCTION rcs_sc_selection, ids

  ; check if id valid

  IF WIDGET_INFO(ids.spacecraft,/VALID_ID) THEN BEGIN

    ; get spacecraft : 0-5 for GSEOS
    ;      0    'PHOENIX'
    ;      1    'RAP_F8'
    ;      2    'RAP_F1'
    ;      3    'RAP_F6'
    ;      4    'RAP_F7'
    ;      5    'RAP_F9'
    ; then droplist index gives S/C

    value = WIDGET_INFO( ids.spacecraft, /DROPLIST_SELECT)

    ; return as single character

    RETURN, rcs_strtrim(value)

  ENDIF ELSE BEGIN

    ; query user for S/C

    items = ['SC1','SC2','SC3','SC4']

    index = rcs_list(items, TITLE='Select S/C', GROUP_LEADER=ids.base, /SINGLE )

    ; return as single character

    RETURN, rcs_strtrim(1+index)

  ENDELSE

END
