;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SET_AUTO
;
; Purpose     :	Sets auto flag.
;
; Explanation : Sets auto flag.
;                 auto = 0 => auto mode off
;                 auto = 1 => auto mode, generate if data, realtime cfg plots
;                 auto = 2 => auto mode, generate if data, single SC survey plots
;                 auto = 3 => auto mode, generate if data, both above plots
;                 auto = 4 => auto mode, generate if data
;
; Use         : < RCS_SET_AUTO, flag>
;
; Inputs      : flag : Flag
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 11/2/01
;
; Modified    : Version 0.1, 21/2/01
;                 Renamed batch --. auto.
;               Version 0.2, 31/05/01
;                 Changed meaning of auto flag.
;
; Version     :	Version 0.2, 31/05/01
;-
;**********************************************************

PRO rcs_set_auto, flag

  COMMON rcs_auto_local, auto

  ; save flag to COMMON

  auto = flag

  ids = rcs_get_ids()

  IF WIDGET_INFO(ids.auto,/VALID_ID) THEN $
    WIDGET_CONTROL, ids.auto, SET_BUTTON=KEYWORD_SET(auto)

END
