;**********************************************************
;+
; Project     :	CLUSTER II - RAPID
;
; Name        :	RCS_SET_FILES
;
; Purpose     :	Saves and displays current file names.
;
; Explanation : Saves and displays current file names.
;
; Use         : < RCS_SET_FILES, n, files >
;
; Inputs      : n     : INT fiel stream
;               files : STRARR(*) file names
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : NOTEXT : FLAG indicating that if non-text widget output then do not print.
;
; Written     :	Version 0.0, Martin Carter, RAL, 27/1/01
;
; Modified    : Version 0.1, 11/2/01
;                 Changed to using silent common block.
;                 Changed to using COMMON block instead of UVALUE.
;               Version 0.2, 2/3/01
;                 Epdate file display.
;               Version 0.3, 13/03/01
;                 Changed use of silent flag.
;
; Version     :	Version 0.3, 13/03/01
;-
;**********************************************************

PRO rcs_set_files, n, files, NOTEXT=notext

  COMMON rcs_in_files_local, files_0, files_1, files_2

  ; save files to COMMON

  CASE n[0] OF
    0 : files_0 = files
    1 : files_1 = files
    2 : files_2 = files
    ELSE : rcs_message, 'IMPLENTATION ERROR'
  ENDCASE

  ; update display

  FOR k = 0, N_ELEMENTS(files)-1 DO rcs_files, n, files[k], APPEND=k NE 0, NOTEXT=notext

END
